import { Observable, isFunction } from '../Observable.js';
import { mapOneOrManyArgs } from '../util/mapOneOrManyArgs.js';
export function fromEventPattern(addHandler, removeHandler, resultSelector) {
    if (resultSelector) {
        return mapOneOrManyArgs(resultSelector)(fromEventPattern(addHandler, removeHandler));
    }
    return new Observable((subscriber) => {
        const handler = (...e) => subscriber.next(e.length === 1 ? e[0] : e);
        const retValue = addHandler(handler);
        return isFunction(removeHandler) ? () => removeHandler(handler, retValue) : undefined;
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/bdbdd3f2cf698f583c5cdd2a6dc0f5aec4ed5f90/node_modules/rxjs/dist/esm/internal/observable/fromEventPattern.js.map