import { Subject } from '../Subject.js';
import { Subscription } from '../Observable.js';
import { observeNotification } from '../Notification.js';
import { logSubscribedFrame, logUnsubscribedFrame } from './subscription-logging.js';
export class HotObservable extends Subject {
    messages;
    scheduler;
    subscriptions = [];
    logSubscribedFrame = logSubscribedFrame;
    logUnsubscribedFrame = logUnsubscribedFrame;
    constructor(messages, scheduler) {
        super();
        this.messages = messages;
        this.scheduler = scheduler;
    }
    _subscribe(subscriber) {
        const index = this.logSubscribedFrame();
        const subscription = new Subscription();
        subscription.add(new Subscription(() => {
            this.logUnsubscribedFrame(index);
        }));
        subscription.add(super._subscribe(subscriber));
        return subscription;
    }
    setup() {
        for (const { notification, frame } of this.messages) {
            this.scheduler.schedule(() => {
                observeNotification(notification, this);
            }, frame);
        }
    }
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/bdbdd3f2cf698f583c5cdd2a6dc0f5aec4ed5f90/node_modules/rxjs/dist/esm/internal/testing/HotObservable.js.map