import { Observable, operate } from '../Observable.js';
export function every(predicate, thisArg) {
    return (source) => new Observable((destination) => {
        let index = 0;
        source.subscribe(operate({
            destination,
            next: (value) => {
                if (!predicate.call(thisArg, value, index++, source)) {
                    destination.next(false);
                    destination.complete();
                }
            },
            complete: () => {
                destination.next(true);
                destination.complete();
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/bdbdd3f2cf698f583c5cdd2a6dc0f5aec4ed5f90/node_modules/rxjs/dist/esm/internal/operators/every.js.map