import { operate, Observable, from } from '../Observable.js';
import { noop } from '../util/noop.js';
export function debounce(durationSelector) {
    return (source) => new Observable((destination) => {
        let hasValue = false;
        let lastValue = null;
        let durationSubscriber = null;
        const emit = () => {
            durationSubscriber?.unsubscribe();
            durationSubscriber = null;
            if (hasValue) {
                hasValue = false;
                const value = lastValue;
                lastValue = null;
                destination.next(value);
            }
        };
        source.subscribe(operate({
            destination,
            next: (value) => {
                durationSubscriber?.unsubscribe();
                hasValue = true;
                lastValue = value;
                durationSubscriber = operate({ destination, next: emit, complete: noop });
                from(durationSelector(value)).subscribe(durationSubscriber);
            },
            complete: () => {
                emit();
                destination.complete();
            },
            finalize: () => {
                lastValue = durationSubscriber = null;
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/bdbdd3f2cf698f583c5cdd2a6dc0f5aec4ed5f90/node_modules/rxjs/dist/esm/internal/operators/debounce.js.map