"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.exhaustMap = void 0;
const Observable_js_1 = require("../Observable.js");
function exhaustMap(project) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let index = 0;
        let innerSub = null;
        let isComplete = false;
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (outerValue) => {
                if (!innerSub) {
                    innerSub = (0, Observable_js_1.operate)({
                        destination,
                        complete: () => {
                            innerSub = null;
                            isComplete && destination.complete();
                        },
                    });
                    (0, Observable_js_1.from)(project(outerValue, index++)).subscribe(innerSub);
                }
            },
            complete: () => {
                isComplete = true;
                !innerSub && destination.complete();
            },
        }));
    });
}
exports.exhaustMap = exhaustMap;//# sourceMappingURL=http://go/sourcemap/sourcemaps/bdbdd3f2cf698f583c5cdd2a6dc0f5aec4ed5f90/node_modules/rxjs/dist/cjs/internal/operators/exhaustMap.js.map