"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.every = void 0;
const Observable_js_1 = require("../Observable.js");
function every(predicate, thisArg) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let index = 0;
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                if (!predicate.call(thisArg, value, index++, source)) {
                    destination.next(false);
                    destination.complete();
                }
            },
            complete: () => {
                destination.next(true);
                destination.complete();
            },
        }));
    });
}
exports.every = every;//# sourceMappingURL=http://go/sourcemap/sourcemaps/bdbdd3f2cf698f583c5cdd2a6dc0f5aec4ed5f90/node_modules/rxjs/dist/cjs/internal/operators/every.js.map