"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.logSubscribedFrame = exports.logUnsubscribedFrame = exports.SubscriptionLog = void 0;
class SubscriptionLog {
    subscribedFrame;
    unsubscribedFrame;
    constructor(subscribedFrame, unsubscribedFrame = Infinity) {
        this.subscribedFrame = subscribedFrame;
        this.unsubscribedFrame = unsubscribedFrame;
    }
}
exports.SubscriptionLog = SubscriptionLog;
function logUnsubscribedFrame(index) {
    const subscriptionLogs = this.subscriptions;
    const oldSubscriptionLog = subscriptionLogs[index];
    subscriptionLogs[index] = new SubscriptionLog(oldSubscriptionLog.subscribedFrame, this.scheduler.now());
}
exports.logUnsubscribedFrame = logUnsubscribedFrame;
function logSubscribedFrame() {
    this.subscriptions.push(new SubscriptionLog(this.scheduler.now()));
    return this.subscriptions.length - 1;
}
exports.logSubscribedFrame = logSubscribedFrame;//# sourceMappingURL=http://go/sourcemap/sourcemaps/bb70f115f7056b569146f670bfeb812a30eaf060/node_modules/rxjs/dist/cjs/internal/testing/subscription-logging.js.map