"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.scheduleIterable = void 0;
const Observable_js_1 = require("../Observable.js");
const iterator_js_1 = require("../symbol/iterator.js");
const executeSchedule_js_1 = require("../util/executeSchedule.js");
function scheduleIterable(input, scheduler) {
    return new Observable_js_1.Observable((subscriber) => {
        let iterator;
        (0, executeSchedule_js_1.executeSchedule)(subscriber, scheduler, () => {
            iterator = input[iterator_js_1.iterator]();
            (0, executeSchedule_js_1.executeSchedule)(subscriber, scheduler, () => {
                let value;
                let done;
                try {
                    ({ value, done } = iterator.next());
                }
                catch (err) {
                    subscriber.error(err);
                    return;
                }
                if (done) {
                    subscriber.complete();
                }
                else {
                    subscriber.next(value);
                }
            }, 0, true);
        });
        return () => (0, Observable_js_1.isFunction)(iterator?.return) && iterator.return();
    });
}
exports.scheduleIterable = scheduleIterable;//# sourceMappingURL=http://go/sourcemap/sourcemaps/bb70f115f7056b569146f670bfeb812a30eaf060/node_modules/rxjs/dist/cjs/internal/scheduled/scheduleIterable.js.map