"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.zip = void 0;
const Observable_js_1 = require("../Observable.js");
const argsOrArgArray_js_1 = require("../util/argsOrArgArray.js");
const empty_js_1 = require("./empty.js");
const args_js_1 = require("../util/args.js");
function zip(...args) {
    const resultSelector = (0, args_js_1.popResultSelector)(args);
    const sources = (0, argsOrArgArray_js_1.argsOrArgArray)(args);
    return sources.length
        ? new Observable_js_1.Observable((destination) => {
            let buffers = sources.map(() => []);
            let completed = sources.map(() => false);
            destination.add(() => {
                buffers = completed = null;
            });
            for (let sourceIndex = 0; !destination.closed && sourceIndex < sources.length; sourceIndex++) {
                (0, Observable_js_1.from)(sources[sourceIndex]).subscribe((0, Observable_js_1.operate)({
                    destination,
                    next: (value) => {
                        buffers[sourceIndex].push(value);
                        if (buffers.every((buffer) => buffer.length)) {
                            const result = buffers.map((buffer) => buffer.shift());
                            destination.next(resultSelector ? resultSelector(...result) : result);
                            if (buffers.some((buffer, i) => !buffer.length && completed[i])) {
                                destination.complete();
                            }
                        }
                    },
                    complete: () => {
                        completed[sourceIndex] = true;
                        !buffers[sourceIndex].length && destination.complete();
                    },
                }));
            }
            return () => {
                buffers = completed = null;
            };
        })
        : empty_js_1.EMPTY;
}
exports.zip = zip;//# sourceMappingURL=http://go/sourcemap/sourcemaps/bb70f115f7056b569146f670bfeb812a30eaf060/node_modules/rxjs/dist/cjs/internal/observable/zip.js.map