import { createRetryingTransport } from './retrying-transport';
import { createXhrTransport } from './transport/xhr-transport';
import { createSendBeaconTransport } from './transport/send-beacon-transport';
import { createOtlpNetworkExportDelegate } from './otlp-network-export-delegate';
import { createFetchTransport } from './transport/fetch-transport';
/**
 * @deprecated use {@link createOtlpFetchExportDelegate}
 */
export function createOtlpXhrExportDelegate(options, serializer) {
    return createOtlpNetworkExportDelegate(options, serializer, createRetryingTransport({
        transport: createXhrTransport(options),
    }));
}
export function createOtlpFetchExportDelegate(options, serializer) {
    return createOtlpNetworkExportDelegate(options, serializer, createRetryingTransport({
        transport: createFetchTransport(options),
    }));
}
export function createOtlpSendBeaconExportDelegate(options, serializer) {
    return createOtlpNetworkExportDelegate(options, serializer, createRetryingTransport({
        transport: createSendBeaconTransport({
            url: options.url,
            headers: options.headers,
        }),
    }));
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/bb70f115f7056b569146f670bfeb812a30eaf060/node_modules/@opentelemetry/otlp-exporter-base/build/esnext/otlp-browser-http-export-delegate.js.map