/** Ways to communicate between the renderer and main process  */
exports.IPCMode = void 0;
(function (IPCMode) {
    /** Configures Electron IPC to receive messages from renderers */
    IPCMode[IPCMode["Classic"] = 1] = "Classic";
    /** Configures Electron protocol module to receive messages from renderers */
    IPCMode[IPCMode["Protocol"] = 2] = "Protocol";
    /**
     * Configures both methods for best compatibility.
     *
     * Renderers favour IPC but fall back to protocol if IPC has not
     * been configured in a preload script
     */
    IPCMode[IPCMode["Both"] = 3] = "Both";
})(exports.IPCMode || (exports.IPCMode = {}));
/**
 * Utility for creating namespaced IPC channels and protocol routes
 */
function ipcChannelUtils(namespace) {
    return {
        createUrl: (channel) => {
            // sentry_key in the url stops these messages from being picked up by our HTTP instrumentations
            return `${namespace}://${channel}/sentry_key`;
        },
        urlMatches: function (url, channel) {
            return url.startsWith(this.createUrl(channel));
        },
        createKey: (channel) => {
            return `${namespace}.${channel}`;
        },
        namespace,
    };
}
const RENDERER_ID_HEADER = 'sentry-electron-renderer-id';
const UTILITY_PROCESS_MAGIC_MESSAGE_KEY = '__sentry_message_port_message__';
/** Does the message look like the magic message */
function isMagicMessage(msg) {
    return !!(msg && typeof msg === 'object' && UTILITY_PROCESS_MAGIC_MESSAGE_KEY in msg);
}
/** Get the magic message to send to the utility process */
function getMagicMessage() {
    return { [UTILITY_PROCESS_MAGIC_MESSAGE_KEY]: true };
}

exports.RENDERER_ID_HEADER = RENDERER_ID_HEADER;
exports.getMagicMessage = getMagicMessage;
exports.ipcChannelUtils = ipcChannelUtils;
exports.isMagicMessage = isMagicMessage;//# sourceMappingURL=http://go/sourcemap/sourcemaps/bb70f115f7056b569146f670bfeb812a30eaf060/node_modules/@sentry/electron/common/ipc.js.map
