import { AsyncLocalStorageContextManager } from '@opentelemetry/context-async-hooks';
import { wrapContextManagerClass } from '@sentry/opentelemetry';

/**
 * This is a custom ContextManager for OpenTelemetry, which extends the default AsyncLocalStorageContextManager.
 * It ensures that we create a new hub per context, so that the OTEL Context & the Sentry Scopes are always in sync.
 *
 * Note that we currently only support AsyncHooks with this,
 * but since this should work for Node 14+ anyhow that should be good enough.
 */
const SentryContextManager = wrapContextManagerClass(AsyncLocalStorageContextManager);

export { SentryContextManager };//# sourceMappingURL=http://go/sourcemap/sourcemaps/bb2dbaacf30bb7eb9fd48a37812a8f326defa530/node_modules/@sentry/node-core/build/esm/otel/contextManager.js.map
