const core = require('@sentry/core');
const ipc = require('../ipc.js');

const eventLoopBlockIntegration = core.defineIntegration((options) => {
    const anrThreshold = options?.threshold ?? 1000;
    const pollInterval = options?.pollInterval || anrThreshold / 2;
    return {
        name: 'EventLoopBlockRenderer',
        setup(client) {
            const config = {
                pollInterval,
                anrThreshold,
                captureStackTrace: true,
                ...options,
            };
            const ipc$1 = ipc.getIPC(client);
            // eslint-disable-next-line no-restricted-globals
            ipc$1.sendStatus({ status: document.visibilityState, config });
            setInterval(() => {
                ipc$1.sendStatus({ status: 'alive', config });
            }, config.pollInterval);
        },
    };
});

exports.eventLoopBlockIntegration = eventLoopBlockIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/bb2dbaacf30bb7eb9fd48a37812a8f326defa530/node_modules/@sentry/electron/renderer/integrations/event-loop-block.js.map
