Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const contextAsyncHooks = require('@opentelemetry/context-async-hooks');
const opentelemetry = require('@sentry/opentelemetry');

/**
 * This is a custom ContextManager for OpenTelemetry, which extends the default AsyncLocalStorageContextManager.
 * It ensures that we create a new hub per context, so that the OTEL Context & the Sentry Scopes are always in sync.
 *
 * Note that we currently only support AsyncHooks with this,
 * but since this should work for Node 14+ anyhow that should be good enough.
 */
const SentryContextManager = opentelemetry.wrapContextManagerClass(contextAsyncHooks.AsyncLocalStorageContextManager);

exports.SentryContextManager = SentryContextManager;//# sourceMappingURL=http://go/sourcemap/sourcemaps/bb2dbaacf30bb7eb9fd48a37812a8f326defa530/node_modules/@sentry/node-core/build/cjs/otel/contextManager.js.map
