import { defineIntegration } from '@sentry/core';
import { startSession, endSessionOnExit } from '../sessions.js';

/** Tracks sessions as the main process lifetime. */
const mainProcessSessionIntegration = defineIntegration((options = {}) => {
    return {
        name: 'MainProcessSession',
        setup() {
            startSession(!!options.sendOnCreate);
            endSessionOnExit();
        },
    };
});

export { mainProcessSessionIntegration };//# sourceMappingURL=http://go/sourcemap/sourcemaps/bb2dbaacf30bb7eb9fd48a37812a8f326defa530/node_modules/@sentry/electron/esm/main/integrations/main-process-session.js.map
