(()=>{"use strict";var t={256:function(t,e,n){var r,s=this&&this.__createBinding||(Object.create?function(t,e,n,r){void 0===r&&(r=n);var s=Object.getOwnPropertyDescriptor(e,n);s&&!("get"in s?!e.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return e[n]}}),Object.defineProperty(t,r,s)}:function(t,e,n,r){void 0===r&&(r=n),t[r]=e[n]}),o=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),i=this&&this.__importStar||(r=function(t){return r=Object.getOwnPropertyNames||function(t){var e=[];for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[e.length]=n);return e},r(t)},function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n=r(t),i=0;i<n.length;i++)"default"!==n[i]&&s(e,t,n[i]);return o(e,t),e});Object.defineProperty(e,"__esModule",{value:!0}),e.activate=async function(t){c.CursorIDEBrowserLogger.init(),c.CursorIDEBrowserLogger.info("Cursor Browser Automation extension activated"),p=new d,await p.initialize();const e=a.cursor.registerMcpProvider(p);t.subscriptions.push(e);const n=a.commands.registerCommand("cursor.browserAutomation.reinjectUIScript",m);t.subscriptions.push(n),m().catch(()=>{})},e.deactivate=async function(){p&&(await p.dispose(),p=void 0)};const a=i(n(398)),c=n(377),l=n(654),u=n(756);class d{constructor(){this.id="cursor-ide-browser",this.featureGateName=void 0,this.instructions="The cursor-ide-browser is an MCP server that allows you to navigate the web and interact with the page. Please use this server if the user is asking about questions or tasks related to frontend / webapp development, and you are encouraged to test any of your code changes by using the tools from this MCP server.",this.tools=[{name:"browser_navigate",description:"Navigate to a URL",parameters:JSON.stringify({type:"object",properties:{url:{type:"string",description:"The URL to navigate to"},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."},position:{type:"string",enum:["active","side"],description:'IMPORTANT: Set to "side" if user mentions "side", "beside", "side panel", or "side by side". Opens browser in side editor group. Defaults to "active" (current editor group).'}},required:["url"]})},{name:"browser_snapshot",description:"Capture accessibility snapshot of the current page, this is better than screenshot",parameters:JSON.stringify({type:"object",properties:{viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:[]})},{name:"browser_click",description:"Perform click on a web page",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to interact with the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},doubleClick:{type:"boolean",description:"Whether to perform a double click instead of a single click"},button:{type:"string",description:"Button to click, defaults to left"},modifiers:{type:"array",items:{type:"string"},description:"Modifier keys to press"},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["element","ref"]})},{name:"browser_type",description:"Type text into editable element",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to interact with the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},text:{type:"string",description:"Text to type into the element"},submit:{type:"boolean",description:"Whether to submit entered text (press Enter after)"},slowly:{type:"boolean",description:"Whether to type one character at a time. Useful for triggering key handlers in the page. By default entire text is filled in at once."},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["element","ref","text"]})},{name:"browser_hover",description:"Hover over element on page",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to interact with the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["element","ref"]})},{name:"browser_select_option",description:"Select an option in a dropdown",parameters:JSON.stringify({type:"object",properties:{element:{type:"string",description:"Human-readable element description used to obtain permission to interact with the element"},ref:{type:"string",description:"Exact target element reference from the page snapshot"},values:{type:"array",items:{type:"string"},description:"Array of values to select in the dropdown. This can be a single value or multiple values."},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["element","ref","values"]})},{name:"browser_press_key",description:"Press a key on the keyboard",parameters:JSON.stringify({type:"object",properties:{key:{type:"string",description:"Name of the key to press or a character to generate, such as ArrowLeft or a"},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["key"]})},{name:"browser_wait_for",description:"Wait for text to appear or disappear or a specified time to pass",parameters:JSON.stringify({type:"object",properties:{time:{type:"number",description:"The time to wait in seconds"},text:{type:"string",description:"The text to wait for"},textGone:{type:"string",description:"The text to wait for to disappear"},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:[]})},{name:"browser_navigate_back",description:"Go back to the previous page",parameters:JSON.stringify({type:"object",properties:{viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:[]})},{name:"browser_resize",description:"Resize the browser window",parameters:JSON.stringify({type:"object",properties:{width:{type:"number",description:"Width of the browser window"},height:{type:"number",description:"Height of the browser window"},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:["width","height"]})},{name:"browser_console_messages",description:"Returns all console messages",parameters:JSON.stringify({type:"object",properties:{viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:[]})},{name:"browser_network_requests",description:"Returns all network requests since loading the page",parameters:JSON.stringify({type:"object",properties:{viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:[]})},{name:"browser_tabs",description:"List, create, close, or select a browser tab",parameters:JSON.stringify({type:"object",properties:{action:{type:"string",enum:["list","new","close","select"],description:"Operation to perform"},index:{type:"number",description:'Tab index. Required for "select". Optional for "close" (defaults to current tab).'},position:{type:"string",enum:["active","side"],description:'IMPORTANT: Set to "side" if user mentions "side", "beside", "side panel", or "side by side". Opens browser in side editor group. Only for action "new". Defaults to "active".'}},required:["action"]})},{name:"browser_take_screenshot",description:"Take a screenshot of the current page. You can't perform actions based on the screenshot, use browser_snapshot for actions.",parameters:JSON.stringify({type:"object",properties:{type:{type:"string",description:"Image format for the screenshot. Default is png."},filename:{type:"string",description:"File name to save the screenshot to. Defaults to page-{timestamp}.{png|jpeg} if not specified."},element:{type:"string",description:"Description of the element, if taking a screenshot of an element"},ref:{type:"string",description:"CSS selector for the element, if taking a screenshot of an element"},fullPage:{type:"boolean",description:"When true, takes a screenshot of the full scrollable page, instead of the currently visible viewport. Cannot be used with element screenshots."},viewId:{type:"string",description:"Target browser tab ID. If omitted, uses the last interacted tab."}},required:[]})}]}async initialize(){c.CursorIDEBrowserLogger.info("Browser Automation MCP Provider initialized with direct execution")}async listOfferings(){return{tools:this.tools,prompts:[],resources:[]}}async callTool(t,e){c.CursorIDEBrowserLogger.info(`Executing tool: ${t} with args: ${JSON.stringify(e)}`);try{switch(t){case"browser_navigate":return await l.BrowserTools.navigate(e);case"browser_snapshot":return await l.BrowserTools.snapshot(e);case"browser_click":return await l.BrowserTools.click(e);case"browser_type":return await l.BrowserTools.type(e);case"browser_hover":return await l.BrowserTools.hover(e);case"browser_select_option":return await l.BrowserTools.selectOption(e);case"browser_press_key":return await l.BrowserTools.pressKey(e);case"browser_wait_for":return await l.BrowserTools.waitFor(e);case"browser_navigate_back":return await l.BrowserTools.goBack(e);case"browser_resize":return await l.BrowserTools.resize(e);case"browser_console_messages":return await l.BrowserTools.consoleMessages(e);case"browser_network_requests":return await l.BrowserTools.networkRequests(e);case"browser_take_screenshot":return await l.BrowserTools.takeScreenshot(e);case"browser_tabs":return await l.BrowserTools.tabs(e);default:throw new Error(`Unknown tool: ${t}`)}}catch(e){throw c.CursorIDEBrowserLogger.error(`Error executing tool ${t}:`,e),e}}async dispose(){c.CursorIDEBrowserLogger.info("Browser Automation MCP Provider disposed")}}let p;async function m(){c.CursorIDEBrowserLogger.info("injectBrowserUIScript called");try{const t=(0,u.generateBrowserUIScript)("browser-tab-id");await a.commands.executeCommand("cursor.browserView.executeJavaScript",t),c.CursorIDEBrowserLogger.info("Browser UI script injected successfully")}catch(t){c.CursorIDEBrowserLogger.error("Failed to inject browser UI script:",t)}}},377:function(t,e,n){var r,s=this&&this.__createBinding||(Object.create?function(t,e,n,r){void 0===r&&(r=n);var s=Object.getOwnPropertyDescriptor(e,n);s&&!("get"in s?!e.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return e[n]}}),Object.defineProperty(t,r,s)}:function(t,e,n,r){void 0===r&&(r=n),t[r]=e[n]}),o=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),i=this&&this.__importStar||(r=function(t){return r=Object.getOwnPropertyNames||function(t){var e=[];for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[e.length]=n);return e},r(t)},function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n=r(t),i=0;i<n.length;i++)"default"!==n[i]&&s(e,t,n[i]);return o(e,t),e});Object.defineProperty(e,"__esModule",{value:!0}),e.CursorIDEBrowserLogger=void 0;const a=i(n(398));class c{constructor(t){this.identifier=t}static init(){this.outputChannel||(this.outputChannel=a.window.createOutputChannel("Cursor IDE Browser Automation"))}static getLogger(t){return this.loggers.has(t)||this.loggers.set(t,new c(t)),this.loggers.get(t)}static info(t){this.log("INFO","general",t)}static warn(t){this.log("WARN","general",t)}static error(t,e){const n=e?`${t}: ${e.message}`:t;this.log("ERROR","general",n),e?.stack&&this.log("ERROR","general",e.stack)}info(t){c.log("INFO",this.identifier,t)}warn(t){c.log("WARN",this.identifier,t)}error(t,e){const n=e?`${t}: ${e.message}`:t;c.log("ERROR",this.identifier,n),e?.stack&&c.log("ERROR",this.identifier,e.stack)}static log(t,e,n){if(this.outputChannel){const r=(new Date).toISOString();this.outputChannel.appendLine(`[${r}] [${t}] [${e}] ${n}`)}}}e.CursorIDEBrowserLogger=c,c.loggers=new Map},398:t=>{t.exports=require("vscode")},654:function(t,e,n){var r,s=this&&this.__createBinding||(Object.create?function(t,e,n,r){void 0===r&&(r=n);var s=Object.getOwnPropertyDescriptor(e,n);s&&!("get"in s?!e.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return e[n]}}),Object.defineProperty(t,r,s)}:function(t,e,n,r){void 0===r&&(r=n),t[r]=e[n]}),o=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),i=this&&this.__importStar||(r=function(t){return r=Object.getOwnPropertyNames||function(t){var e=[];for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&(e[e.length]=n);return e},r(t)},function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n=r(t),i=0;i<n.length;i++)"default"!==n[i]&&s(e,t,n[i]);return o(e,t),e});Object.defineProperty(e,"__esModule",{value:!0}),e.BrowserTools=void 0;const a=i(n(398)),c=i(n(943)),l=i(n(928)),u=i(n(857)),d=n(377),p=l.join(u.homedir(),".cursor","browser-logs");async function m(t,e){const n=await a.commands.executeCommand("cursor.browserView.getURL",e);await a.commands.executeCommand("cursor.browserOriginAllowlist.ensurePageOriginAllowed",{toolName:t,url:n})}function g(t,e=0){const n="  ".repeat(e),r=[];if(t.role&&r.push(`${n}- role: ${t.role}`),t.name){const e=String(t.name).replace(/\n/g," ").trim();e.includes(":")||e.includes('"')||e.includes("[")?r.push(`${n}  name: "${e.replace(/"/g,'\\"')}"`):r.push(`${n}  name: ${e}`)}if(t.ref&&r.push(`${n}  ref: ${t.ref}`),t.children&&t.children.length>0){r.push(`${n}  children:`);for(const n of t.children)r.push(g(n,e+2))}return r.join("\n")}const h="\nfunction buildPageSnapshot(depth = 0, maxDepth = 20) {\n    function getTextFromIds(ids) {\n        try {\n            if (!ids) return '';\n            const parts = [];\n            ids.split(/s+/).forEach(id => {\n                const el = document.getElementById(id);\n                if (el) {\n                    const t = (el.innerText || el.textContent || '').trim();\n                    if (t) parts.push(t);\n                }\n            });\n            return parts.join(' ').trim();\n        } catch (_) { return ''; }\n    }\n\n    function getVisibleText(el) {\n        try {\n            const walker = document.createTreeWalker(\n                el,\n                NodeFilter.SHOW_TEXT,\n                {\n                    acceptNode(node) {\n                        if (!node.textContent || !node.textContent.trim()) {\n                            return NodeFilter.FILTER_REJECT;\n                        }\n                        const parent = node.parentElement;\n                        if (parent) {\n                            const style = window.getComputedStyle(parent);\n                            if (style && (style.visibility === 'hidden' || style.display === 'none')) {\n                                return NodeFilter.FILTER_REJECT;\n                            }\n                        }\n                        return NodeFilter.FILTER_ACCEPT;\n                    }\n                }\n            );\n            const parts = [];\n            while (walker.nextNode()) {\n                const text = walker.currentNode.textContent || '';\n                const clean = text.replace(/s+/g, ' ').trim();\n                if (clean) {\n                    parts.push(clean);\n                    if (parts.join(' ').length > 240) {\n                        break;\n                    }\n                }\n            }\n            if (parts.length) {\n                return parts.join(' ').trim().substring(0, 200);\n            }\n            const fallback = (el.innerText || el.textContent || '').replace(/s+/g, ' ').trim();\n            return fallback.substring(0, 200);\n        } catch (_) {\n            try {\n                const text = (el.innerText || '').replace(/s+/g, ' ').trim();\n                return text.substring(0, 200);\n            } catch (_) {\n                return '';\n            }\n        }\n    }\n\n    function getLabelsText(el) {\n        try {\n            const labels = (el.labels && Array.from(el.labels)) || [];\n            if (!labels.length) return '';\n            const labelText = labels\n                .map(label => getVisibleText(label) || (label.textContent || '').trim())\n                .filter(Boolean)\n                .join(' ')\n                .trim();\n            return labelText.substring(0, 200);\n        } catch (_) {\n            return '';\n        }\n    }\n\n    function getImplicitRole(el) {\n        try {\n            const tag = el.tagName ? el.tagName.toLowerCase() : '';\n            switch (tag) {\n                case 'a':\n                    return el.hasAttribute('href') ? 'link' : 'generic';\n                case 'button':\n                    return 'button';\n                case 'input': {\n                    const type = (el.getAttribute('type') || 'text').toLowerCase();\n                    switch (type) {\n                        case 'button':\n                        case 'submit':\n                        case 'reset':\n                            return 'button';\n                        case 'checkbox':\n                            return 'checkbox';\n                        case 'radio':\n                            return 'radio';\n                        case 'range':\n                            return 'slider';\n                        case 'number':\n                            return 'spinbutton';\n                        default:\n                            return 'textbox';\n                    }\n                }\n                case 'select':\n                    return el.hasAttribute('multiple') || Number(el.getAttribute('size') || 0) > 1 ? 'listbox' : 'combobox';\n                case 'option':\n                    return 'option';\n                case 'textarea':\n                    return 'textbox';\n                case 'img':\n                    return 'img';\n                case 'ul':\n                case 'ol':\n                    return 'list';\n                case 'li':\n                    return 'listitem';\n                case 'nav':\n                    return 'navigation';\n                case 'main':\n                    return 'main';\n                case 'header':\n                    return 'banner';\n                case 'footer':\n                    return 'contentinfo';\n                case 'form':\n                    return 'form';\n                case 'table':\n                    return 'table';\n                case 'tr':\n                    return 'row';\n                case 'td':\n                    return 'cell';\n                case 'th':\n                    return 'columnheader';\n                case 'section':\n                case 'article':\n                case 'aside':\n                    return tag;\n                case 'summary':\n                    return 'button';\n                case 'details':\n                    return 'group';\n                case 'progress':\n                    return 'progressbar';\n                case 'meter':\n                    return 'meter';\n                case 'label':\n                    return 'label';\n                case 'h1':\n                case 'h2':\n                case 'h3':\n                case 'h4':\n                case 'h5':\n                case 'h6':\n                    return 'heading';\n                case 'svg':\n                    return 'img';\n                default:\n                    return 'generic';\n            }\n        } catch (_) {\n            return 'generic';\n        }\n    }\n\n    function computeAccessibleName(el, role) {\n        try {\n            if (!el || el.getAttribute('aria-hidden') === 'true') {\n                return '';\n            }\n\n            const labelledBy = el.getAttribute('aria-labelledby');\n            const fromLabelledBy = getTextFromIds(labelledBy);\n            if (fromLabelledBy) return fromLabelledBy.substring(0, 200);\n\n            const ariaLabel = (el.getAttribute('aria-label') || '').trim();\n            if (ariaLabel) return ariaLabel.substring(0, 200);\n\n            const ariaPlaceholder = (el.getAttribute('aria-placeholder') || '').trim();\n            if (ariaPlaceholder) return ariaPlaceholder.substring(0, 200);\n\n            const labelsText = getLabelsText(el);\n            if (labelsText) return labelsText.substring(0, 200);\n\n            const tag = el.tagName ? el.tagName.toLowerCase() : '';\n\n            if (tag === 'img') {\n                const alt = (el.getAttribute('alt') || '').trim();\n                if (alt) return alt.substring(0, 200);\n            }\n\n            if (tag === 'input') {\n                const type = (el.getAttribute('type') || 'text').toLowerCase();\n                const value = el.value || el.getAttribute('value') || '';\n                const placeholder = (el.getAttribute('placeholder') || '').trim();\n                if (type === 'button' || type === 'submit' || type === 'reset') {\n                    if (value) return String(value).substring(0, 200);\n                }\n                if (placeholder) return placeholder.substring(0, 200);\n                if (value && type !== 'password') return String(value).substring(0, 200);\n            }\n\n            if (tag === 'textarea') {\n                const placeholder = (el.getAttribute('placeholder') || '').trim();\n                if (placeholder) return placeholder.substring(0, 200);\n                if (el.value) return String(el.value).substring(0, 200);\n            }\n\n            if (tag === 'select') {\n                const selected = Array.from(el.selectedOptions || [])\n                    .map(option => getVisibleText(option) || (option.textContent || '').trim())\n                    .filter(Boolean)\n                    .join(', ')\n                    .trim();\n                if (selected) return selected.substring(0, 200);\n            }\n\n            const roleLower = (role || '').toLowerCase();\n            const interactiveRoles = new Set(['button', 'link', 'menuitem', 'option', 'tab', 'checkbox', 'radio', 'switch', 'combobox', 'textbox', 'listbox', 'slider', 'spinbutton', 'cell', 'gridcell', 'row', 'columnheader', 'rowheader']);\n            const interactiveTags = new Set(['button', 'a', 'summary', 'label', 'option', 'textarea', 'select', 'time']);\n            const headingTags = new Set(['h1','h2','h3','h4','h5','h6']);\n            if (interactiveRoles.has(roleLower) || interactiveTags.has(tag) || headingTags.has(tag)) {\n                const visible = getVisibleText(el);\n                if (visible) return visible.substring(0, 200);\n            }\n\n            if (tag === 'p' || tag === 'li' || roleLower === 'heading') {\n                const visible = getVisibleText(el);\n                if (visible) return visible.substring(0, 200);\n            }\n\n            const title = (el.getAttribute('title') || '').trim();\n            if (title) return title.substring(0, 200);\n\n            return '';\n        } catch (_) {\n            return '';\n        }\n    }\n\n    function collectElementStates(el, role) {\n        const states = [];\n        try {\n            if (document.activeElement === el) states.push('focused');\n            if (el.matches && el.matches(':checked')) states.push('checked');\n            if (el.matches && el.matches(':disabled')) states.push('disabled');\n            if (el.matches && el.matches(':required')) states.push('required');\n            if (el.matches && el.matches(':read-only')) states.push('readonly');\n            if (el.selected) states.push('selected');\n            const ariaSelected = el.getAttribute('aria-selected');\n            if (ariaSelected === 'true') states.push('selected');\n            const ariaExpanded = el.getAttribute('aria-expanded');\n            if (ariaExpanded === 'true') states.push('expanded');\n            if (ariaExpanded === 'false') states.push('collapsed');\n            const ariaPressed = el.getAttribute('aria-pressed');\n            if (ariaPressed === 'true') states.push('pressed');\n            if (ariaPressed === 'false') states.push('released');\n            if (el.getAttribute && el.getAttribute('aria-current')) states.push('current');\n            if (el.getAttribute && el.getAttribute('aria-invalid') === 'true') states.push('invalid');\n            if (el.getAttribute && el.getAttribute('aria-busy') === 'true') states.push('busy');\n        } catch (_) { }\n        return Array.from(new Set(states));\n    }\n\n    function collectElementDetails(el, role) {\n        const details = {};\n        try {\n            const tag = el.tagName ? el.tagName.toLowerCase() : '';\n            const ariaDescription = (el.getAttribute('aria-description') || '').trim();\n            if (ariaDescription) {\n                details.description = ariaDescription.substring(0, 200);\n            }\n            const describedBy = getTextFromIds(el.getAttribute('aria-describedby'));\n            if (describedBy) {\n                details.description = details.description\n                    ? (details.description + ' ' + describedBy.substring(0, 200)).trim()\n                    : describedBy.substring(0, 200);\n            }\n            if (tag === 'a' && el.hasAttribute('href')) {\n                details.url = el.getAttribute('href');\n            }\n            if ((tag === 'img' || tag === 'svg') && el.hasAttribute('src')) {\n                details.src = el.getAttribute('src');\n            }\n            if (tag === 'input' || tag === 'textarea') {\n                const type = (el.getAttribute('type') || 'text').toLowerCase();\n                const value = el.value || el.getAttribute('value') || '';\n                if (value && (tag !== 'input' || type !== 'password')) {\n                    details.value = String(value).substring(0, 200);\n                }\n                const placeholder = (el.getAttribute('placeholder') || '').trim();\n                if (placeholder) {\n                    details.placeholder = placeholder.substring(0, 200);\n                }\n            }\n            if (tag === 'select') {\n                const selected = Array.from(el.selectedOptions || [])\n                    .map(option => getVisibleText(option) || (option.textContent || '').trim())\n                    .filter(Boolean);\n                if (selected.length) {\n                    details.value = selected.join(', ').substring(0, 200);\n                }\n            }\n            if (role === 'combobox' && el.getAttribute('aria-activedescendant')) {\n                details.activeDescendant = el.getAttribute('aria-activedescendant');\n            }\n        } catch (_) { }\n        return details;\n    }\n\n    function shouldIncludeElement(el) {\n        try {\n            if (!el || el.getAttribute('aria-hidden') === 'true') {\n                return false;\n            }\n            const tag = el.tagName ? el.tagName.toLowerCase() : '';\n            const role = el.getAttribute('role') || getImplicitRole(el);\n            const meaningfulTags = new Set(['a', 'button', 'input', 'select', 'textarea', 'img', 'svg', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'nav', 'main', 'header', 'footer', 'section', 'article', 'form', 'label', 'ul', 'ol', 'li', 'p', 'strong', 'em', 'small', 'time', 'option', 'summary', 'details']);\n            if (meaningfulTags.has(tag)) {\n                return true;\n            }\n            if (role && role !== 'generic') {\n                return true;\n            }\n            if (el.getAttribute('aria-label') || el.getAttribute('aria-labelledby')) {\n                return true;\n            }\n            if (el.matches && el.matches('[contenteditable=\"true\"]')) {\n                return true;\n            }\n            if (el.querySelector && el.querySelector('a, button, input, select, textarea, [role], [contenteditable=\"true\"]')) {\n                return true;\n            }\n        } catch (_) {\n            return true;\n        }\n        return false;\n    }\n\n    function buildAccessibilityTree(element, depth = 0, maxDepth = 20) {\n        if (!element || depth > maxDepth) return null;\n\n        let ref = element.getAttribute && element.getAttribute('data-cursor-ref');\n        if (!ref && element.setAttribute) {\n            ref = 'ref-' + Math.random().toString(36).substring(2, 15);\n            element.setAttribute('data-cursor-ref', ref);\n        }\n\n        const tag = element.tagName ? element.tagName.toLowerCase() : 'generic';\n        const roleAttr = (element.getAttribute && element.getAttribute('role')) || '';\n        const implicitRole = getImplicitRole(element);\n        const role = (roleAttr || implicitRole || tag || 'generic');\n        const name = computeAccessibleName(element, role);\n\n        const node = {\n            ref,\n            role,\n            name,\n            tag,\n            children: []\n        };\n\n        if (role === 'heading') {\n            const ariaLevel = parseInt(element.getAttribute('aria-level') || '', 10);\n            const tagLevelMatch = tag.match(/^h([1-6])$/);\n            const tagLevel = tagLevelMatch ? parseInt(tagLevelMatch[1], 10) : undefined;\n            const level = !Number.isNaN(ariaLevel) ? ariaLevel : tagLevel;\n            if (level) {\n                node.level = level;\n            }\n        }\n\n        const states = collectElementStates(element, role);\n        if (states.length) {\n            node.states = states;\n        }\n\n        const details = collectElementDetails(element, role);\n        for (const key in details) {\n            if (Object.prototype.hasOwnProperty.call(details, key) && details[key] !== undefined && details[key] !== '') {\n                node[key] = details[key];\n            }\n        }\n\n        const children = [];\n        if (element.children) {\n            for (const child of Array.from(element.children)) {\n                if (!shouldIncludeElement(child)) {\n                    continue;\n                }\n                const childNode = buildAccessibilityTree(child, depth + 1, maxDepth);\n                if (childNode) {\n                    children.push(childNode);\n                }\n            }\n        }\n\n        node.children = children;\n        return node;\n    }\n\n    return buildAccessibilityTree(document.body, depth, maxDepth);\n}\n";async function w(t,e){try{return await a.commands.executeCommand("cursor.browserView.executeJavaScript",t,e)}catch(t){throw d.CursorIDEBrowserLogger.error("Failed to execute JavaScript in browser:",t),t}}async function b(t){const{action:e,detailLines:n,pageState:r}=t;if(r?.snapshot){const t=g(r.snapshot),s=r.url,o=r.title,i=Buffer.byteLength(t,"utf8");if(i>25600)try{const{filePath:r,previewLines:a,totalLines:u}=await async function(t){await c.mkdir(p,{recursive:!0});const e=`snapshot-${(new Date).toISOString().replace(/[:.]/g,"-")}.log`,n=l.join(p,e),r=t.split("\n"),s=r.length,o=r.slice(0,Math.min(50,s));return await c.writeFile(n,t,"utf8"),d.CursorIDEBrowserLogger.info(`Large snapshot redirected to: ${n} (${s} lines, ${o.length} preview lines)`),{filePath:n,previewLines:o,totalLines:s}}(t),m=[];return m.push(`### Action: ${e}`),n&&n.length>0&&m.push(...n),m.push("\n### Page state",`- Page URL: ${s}`,`- Page Title: ${o}`,`- Page Snapshot: Large snapshot (${i} bytes, ${u} lines) written to file`,`- Snapshot File: [${r}](file://${r})`,`- Preview (first ${a.length} lines):`,"```yaml",a.join("\n"),"```",`\n... (${u-a.length} more lines in file)`),{content:[{type:"text",text:m.join("\n")}]}}catch(t){d.CursorIDEBrowserLogger.error("Failed to write snapshot to file, returning inline:",t)}const a=[];return a.push(`### Action: ${e}`),n&&n.length>0&&a.push(...n),a.push("\n### Page state",`- Page URL: ${s}`,`- Page Title: ${o}`,"- Page Snapshot:","```yaml",t,"```"),{content:[{type:"text",text:a.join("\n")}]}}return{content:[{type:"text",text:JSON.stringify(t)}]}}e.BrowserTools={async navigate(t){await async function(t){await a.commands.executeCommand("cursor.browserOriginAllowlist.ensureNavigationAllowed",{url:t})}(t.url),d.CursorIDEBrowserLogger.info(`Navigating to ${t.url}`);const n=await a.commands.executeCommand("cursor.browserView.listTabs"),r=n?.tabs??[];if(t.viewId||r.length>0){const n=t.viewId||r[0];return await a.commands.executeCommand("cursor.browserView.navigate",t.url,n),await new Promise(t=>setTimeout(t,1e3)),await e.BrowserTools.snapshot({viewId:n})}const s=t.position?{position:t.position}:void 0,o=await a.commands.executeCommand("cursor.browserView.newTab",t.url,s);return o?.browserId?(await new Promise(t=>setTimeout(t,1e3)),await e.BrowserTools.snapshot({viewId:o.browserId})):{content:[{type:"text",text:"Failed to create new browser tab"}]}},async snapshot(t){await m("browser_snapshot",t.viewId);const e=`\n\t\t\t${h}\n\t\t\t(function() {\n\t\t\t\tconst tree = buildPageSnapshot();\n\t\t\t\treturn {\n\t\t\t\t\tsuccess: true,\n\t\t\t\t\tpageState: {\n\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\tsnapshot: tree\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t})();\n\t\t`,n=await w(e,t.viewId);return await b({action:"snapshot",pageState:n.pageState})},async click(t){await m("browser_click",t.viewId);const e=`\n\t\t\t${h}\n\t\t\t(function() {\n\t\t\t\tconst ref = ${JSON.stringify(t.ref)};\n\t\t\t\tconst element = document.querySelector('[data-cursor-ref="' + ref + '"]');\n\t\t\t\tif (!element) throw new Error('Element not found');\n\n\t\t\t\tconst rect = element.getBoundingClientRect();\n\t\t\t\tconst cx = Math.round(rect.left + rect.width / 2);\n\t\t\t\tconst cy = Math.round(rect.top + rect.height / 2);\n\n\t\t\t\t// Scroll into view if needed\n\t\t\t\tif (rect.top < 0 || rect.left < 0 || rect.bottom > window.innerHeight || rect.right > window.innerWidth) {\n\t\t\t\t\telement.scrollIntoView({ block: 'center', inline: 'center', behavior: 'auto' });\n\t\t\t\t}\n\n\t\t\t\tconst buttonValue = ${JSON.stringify(t.button)} === 'right' ? 2 :\n\t\t\t\t\t${JSON.stringify(t.button)} === 'middle' ? 1 : 0;\n\n\t\t\t\tconst modifiers = ${JSON.stringify(t.modifiers||[])};\n\t\t\t\tconst mouseEventOptions = {\n\t\t\t\t\tbubbles: true,\n\t\t\t\t\tcancelable: true,\n\t\t\t\t\tview: window,\n\t\t\t\t\tbutton: buttonValue,\n\t\t\t\t\tbuttons: 1 << buttonValue,\n\t\t\t\t\tctrlKey: modifiers.includes('Control') || modifiers.includes('ControlOrMeta'),\n\t\t\t\t\tshiftKey: modifiers.includes('Shift'),\n\t\t\t\t\taltKey: modifiers.includes('Alt'),\n\t\t\t\t\tmetaKey: modifiers.includes('Meta') || modifiers.includes('ControlOrMeta'),\n\t\t\t\t\tclientX: cx,\n\t\t\t\t\tclientY: cy\n\t\t\t\t};\n\n\t\t\t\tif (element.focus) element.focus();\n\n\t\t\t\telement.dispatchEvent(new MouseEvent('mousedown', mouseEventOptions));\n\t\t\t\telement.dispatchEvent(new MouseEvent('mouseup', mouseEventOptions));\n\t\t\t\telement.dispatchEvent(new MouseEvent('click', mouseEventOptions));\n\n\t\t\t\tif (${JSON.stringify(t.doubleClick)}) {\n\t\t\t\t\telement.dispatchEvent(new MouseEvent('mousedown', mouseEventOptions));\n\t\t\t\t\telement.dispatchEvent(new MouseEvent('mouseup', mouseEventOptions));\n\t\t\t\t\telement.dispatchEvent(new MouseEvent('click', mouseEventOptions));\n\t\t\t\t\telement.dispatchEvent(new MouseEvent('dblclick', mouseEventOptions));\n\t\t\t\t}\n\n\t\t\t\tconst snapshot = buildPageSnapshot();\n\t\t\t\treturn {\n\t\t\t\t\tsuccess: true,\n\t\t\t\t\tdoubleClick: ${JSON.stringify(t.doubleClick)} || false,\n\t\t\t\t\tbutton: ${JSON.stringify(t.button)} || 'left',\n\t\t\t\t\tpageState: {\n\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\tsnapshot: snapshot\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t})();\n\t\t`,n=await w(e,t.viewId),r=[];return r.push("- Click type: "+(n.doubleClick?"double-click":"single-click")),r.push(`- Button: ${n.button}`),await b({action:"click",detailLines:r,pageState:n.pageState})},async type(t){await m("browser_type",t.viewId);const e=`\n\t\t\t${h}\n\t\t\t(function() {\n\t\t\t\tconst ref = ${JSON.stringify(t.ref)};\n\t\t\t\tconst element = document.querySelector('[data-cursor-ref="' + ref + '"]');\n\t\t\t\tif (!element) throw new Error('Element not found');\n\n\t\t\t\telement.focus();\n\t\t\t\tconst text = ${JSON.stringify(t.text)};\n\t\t\t\tconst slowly = ${JSON.stringify(t.slowly)} || false;\n\t\t\t\tconst submit = ${JSON.stringify(t.submit)} || false;\n\n\t\t\t\tconst isContentEditable = element.isContentEditable;\n\n\t\t\t\tif (slowly) {\n\t\t\t\t\t// Type one character at a time\n\t\t\t\t\tconst delay = 50;\n\t\t\t\t\tfor (let i = 0; i < text.length; i++) {\n\t\t\t\t\t\tconst char = text[i];\n\t\t\t\t\t\tif (isContentEditable) {\n\t\t\t\t\t\t\tconst selection = window.getSelection();\n\t\t\t\t\t\t\tconst range = document.createRange();\n\t\t\t\t\t\t\trange.selectNodeContents(element);\n\t\t\t\t\t\t\trange.collapse(false);\n\t\t\t\t\t\t\tselection.removeAllRanges();\n\t\t\t\t\t\t\tselection.addRange(range);\n\t\t\t\t\t\t\tdocument.execCommand('insertText', false, char);\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\telement.value = text.substring(0, i + 1);\n\t\t\t\t\t\t}\n\t\t\t\t\t\telement.dispatchEvent(new KeyboardEvent('keydown', { key: char, bubbles: true, cancelable: true }));\n\t\t\t\t\t\telement.dispatchEvent(new Event('input', { bubbles: true }));\n\t\t\t\t\t\telement.dispatchEvent(new KeyboardEvent('keyup', { key: char, bubbles: true, cancelable: true }));\n\t\t\t\t\t\t// Small delay between characters\n\t\t\t\t\t\tconst startTime = Date.now();\n\t\t\t\t\t\twhile (Date.now() - startTime < delay) { /* busy wait */ }\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tif (isContentEditable) {\n\t\t\t\t\t\telement.textContent = text;\n\t\t\t\t\t} else {\n\t\t\t\t\t\telement.value = text;\n\t\t\t\t\t}\n\t\t\t\t\telement.dispatchEvent(new Event('input', { bubbles: true }));\n\t\t\t\t}\n\n\t\t\t\telement.dispatchEvent(new Event('change', { bubbles: true }));\n\n\t\t\t\tif (submit) {\n\t\t\t\t\telement.dispatchEvent(new KeyboardEvent('keydown', { key: 'Enter', keyCode: 13, code: 'Enter', which: 13, bubbles: true, cancelable: true }));\n\t\t\t\t\telement.dispatchEvent(new KeyboardEvent('keypress', { key: 'Enter', keyCode: 13, code: 'Enter', which: 13, bubbles: true, cancelable: true }));\n\t\t\t\t\telement.dispatchEvent(new KeyboardEvent('keyup', { key: 'Enter', keyCode: 13, code: 'Enter', which: 13, bubbles: true, cancelable: true }));\n\t\t\t\t}\n\n\t\t\t\tconst snapshot = buildPageSnapshot();\n\t\t\t\treturn {\n\t\t\t\t\tsuccess: true,\n\t\t\t\t\tslowly,\n\t\t\t\t\tsubmitted: submit,\n\t\t\t\t\ttextLength: text.length,\n\t\t\t\t\tpageState: {\n\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\tsnapshot: snapshot\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t})();\n\t\t`,n=await w(e,t.viewId),r=[];return r.push(`- Characters typed: ${n.textLength}`),r.push("- Typing mode: "+(n.slowly?"slow (character-by-character)":"fast")),n.submitted&&r.push("- Form submitted: yes (Enter key pressed)"),await b({action:"type",detailLines:r,pageState:n.pageState})},async hover(t){await m("browser_hover",t.viewId);const e=`\n\t\t\t${h}\n\t\t\t(function() {\n\t\t\t\tconst ref = ${JSON.stringify(t.ref)};\n\t\t\t\tconst element = document.querySelector('[data-cursor-ref="' + ref + '"]');\n\t\t\t\tif (!element) throw new Error('Element not found');\n\n\t\t\t\tconst rect = element.getBoundingClientRect();\n\t\t\t\tconst hx = Math.round(rect.left + rect.width / 2);\n\t\t\t\tconst hy = Math.round(rect.top + rect.height / 2);\n\n\t\t\t\tconst mouseEventOptions = {\n\t\t\t\t\tbubbles: true,\n\t\t\t\t\tcancelable: true,\n\t\t\t\t\tview: window\n\t\t\t\t};\n\n\t\t\t\telement.dispatchEvent(new MouseEvent('mouseenter', { ...mouseEventOptions, clientX: hx, clientY: hy }));\n\t\t\t\telement.dispatchEvent(new MouseEvent('mouseover', { ...mouseEventOptions, clientX: hx, clientY: hy }));\n\t\t\t\telement.dispatchEvent(new MouseEvent('mousemove', { ...mouseEventOptions, clientX: hx, clientY: hy }));\n\n\t\t\t\tconst snapshot = buildPageSnapshot();\n\t\t\t\treturn {\n\t\t\t\t\tsuccess: true,\n\t\t\t\t\tpageState: {\n\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\tsnapshot: snapshot\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t})();\n\t\t`,n=await w(e,t.viewId);return await b({action:"hover",pageState:n.pageState})},async selectOption(t){await m("browser_select_option",t.viewId);const e=`\n\t\t\t${h}\n\t\t\t(function() {\n\t\t\t\tconst ref = ${JSON.stringify(t.ref)};\n\t\t\t\tconst element = document.querySelector('[data-cursor-ref="' + ref + '"]');\n\t\t\t\tif (!element) throw new Error('Element not found');\n\n\t\t\t\tconst selectElement = element;\n\t\t\t\tconst values = ${JSON.stringify(t.values)};\n\n\t\t\t\tif (!selectElement.multiple) {\n\t\t\t\t\tselectElement.value = '';\n\t\t\t\t} else {\n\t\t\t\t\tArray.from(selectElement.options).forEach(option => {\n\t\t\t\t\t\toption.selected = false;\n\t\t\t\t\t});\n\t\t\t\t}\n\n\t\t\t\tconst selectedValues = [];\n\t\t\t\tfor (const value of values) {\n\t\t\t\t\tlet optionFound = false;\n\t\t\t\t\tfor (const option of selectElement.options) {\n\t\t\t\t\t\tif (option.value === value) {\n\t\t\t\t\t\t\toption.selected = true;\n\t\t\t\t\t\t\tselectedValues.push(value);\n\t\t\t\t\t\t\toptionFound = true;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tif (!optionFound) {\n\t\t\t\t\t\tthrow new Error('Option with value "' + value + '" not found');\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tselectElement.dispatchEvent(new Event('input', { bubbles: true }));\n\t\t\t\tselectElement.dispatchEvent(new Event('change', { bubbles: true }));\n\n\t\t\t\tconst snapshot = buildPageSnapshot();\n\t\t\t\treturn {\n\t\t\t\t\tsuccess: true,\n\t\t\t\t\tselectedValues,\n\t\t\t\t\tpageState: {\n\t\t\t\t\t\turl: window.location.href,\n\t\t\t\t\t\ttitle: document.title,\n\t\t\t\t\t\tsnapshot: snapshot\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t})();\n\t\t`,n=await w(e,t.viewId),r=[];return n.selectedValues.length>0?r.push(`- Selected values: ${n.selectedValues.join(", ")}`):r.push("- Selected values: (none)"),await b({action:"select_option",detailLines:r,pageState:n.pageState})},async pressKey(t){await m("browser_press_key",t.viewId);const e=`\n\t\t\t(function() {\n\t\t\t\tconst key = ${JSON.stringify(t.key)};\n\n\t\t\t\tconst scrollAmounts = {\n\t\t\t\t\t'PageDown': { x: 0, y: window.innerHeight * 0.8 },\n\t\t\t\t\t'PageUp': { x: 0, y: -window.innerHeight * 0.8 },\n\t\t\t\t\t'ArrowDown': { x: 0, y: 40 },\n\t\t\t\t\t'ArrowUp': { x: 0, y: -40 },\n\t\t\t\t\t'End': { x: 0, y: document.documentElement.scrollHeight - window.scrollY },\n\t\t\t\t\t'Home': { x: 0, y: -window.scrollY },\n\t\t\t\t\t'Space': { x: 0, y: window.innerHeight * 0.8 },\n\t\t\t\t\t' ': { x: 0, y: window.innerHeight * 0.8 },\n\t\t\t\t};\n\n\t\t\t\tconst keyCodeMap = {\n\t\t\t\t\t'PageDown': 34, 'PageUp': 33, 'End': 35, 'Home': 36,\n\t\t\t\t\t'ArrowLeft': 37, 'ArrowUp': 38, 'ArrowRight': 39, 'ArrowDown': 40,\n\t\t\t\t\t'Enter': 13, 'Escape': 27, 'Tab': 9, 'Backspace': 8, 'Delete': 46,\n\t\t\t\t\t'Space': 32, ' ': 32\n\t\t\t\t};\n\n\t\t\t\tif (scrollAmounts[key]) {\n\t\t\t\t\twindow.scrollBy({ left: scrollAmounts[key].x, top: scrollAmounts[key].y, behavior: 'auto' });\n\t\t\t\t}\n\n\t\t\t\tconst keyCode = keyCodeMap[key] || (key.length === 1 ? key.charCodeAt(0) : 0);\n\t\t\t\tconst activeElement = document.activeElement || document.body;\n\t\t\t\tconst eventInit = { key, code: key, keyCode, which: keyCode, bubbles: true, cancelable: true };\n\n\t\t\t\tactiveElement.dispatchEvent(new KeyboardEvent('keydown', eventInit));\n\t\t\t\tactiveElement.dispatchEvent(new KeyboardEvent('keypress', eventInit));\n\t\t\t\tactiveElement.dispatchEvent(new KeyboardEvent('keyup', eventInit));\n\n\t\t\t\treturn { action: 'press_key', success: true, key };\n\t\t\t})();\n\t\t`,n=await w(e,t.viewId);return n.success?{content:[{type:"text",text:`Successfully pressed key: ${n.key}`}]}:{content:[{type:"text",text:`Failed to press key: ${n.key}`}]}},async waitFor(t){if(await m("browser_wait_for",t.viewId),void 0!==t.time)return await new Promise(e=>setTimeout(e,1e3*t.time)),{content:[{type:"text",text:`Successfully waited for: ${t.time} seconds`}]};const e=`\n\t\t\t(function() {\n\t\t\t\tconst targetText = ${JSON.stringify(t.text||t.textGone)};\n\t\t\t\tconst waitForDisappear = ${JSON.stringify(!!t.textGone)};\n\t\t\t\tconst timeout = 30000;\n\t\t\t\tconst startTime = Date.now();\n\n\t\t\t\treturn new Promise((resolve) => {\n\t\t\t\t\tconst checkInterval = setInterval(() => {\n\t\t\t\t\t\tconst bodyText = document.body.innerText || document.body.textContent || '';\n\t\t\t\t\t\tconst found = bodyText.includes(targetText);\n\n\t\t\t\t\t\tif (waitForDisappear ? !found : found) {\n\t\t\t\t\t\t\tclearInterval(checkInterval);\n\t\t\t\t\t\t\tresolve({\n\t\t\t\t\t\t\t\taction: 'wait_for',\n\t\t\t\t\t\t\t\tsuccess: true,\n\t\t\t\t\t\t\t\ttype: waitForDisappear ? 'text_gone' : 'text_appear',\n\t\t\t\t\t\t\t\ttext: targetText\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif (Date.now() - startTime > timeout) {\n\t\t\t\t\t\t\tclearInterval(checkInterval);\n\t\t\t\t\t\t\tresolve({\n\t\t\t\t\t\t\t\taction: 'wait_for',\n\t\t\t\t\t\t\t\tsuccess: false,\n\t\t\t\t\t\t\t\terror: 'Timeout waiting for text',\n\t\t\t\t\t\t\t\ttype: waitForDisappear ? 'text_gone' : 'text_appear',\n\t\t\t\t\t\t\t\ttext: targetText\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\t\t\t\t\t}, 500);\n\t\t\t\t});\n\t\t\t})();\n\t\t`,{success:n,type:r,text:s,error:o}=await w(e,t.viewId);return n?{content:[{type:"text",text:`Successfully waited for element: ${s||"Unknown text"}`}]}:{content:[{type:"text",text:`Failed to wait for element: ${o||"Unknown error"}`}]}},async consoleMessages(t){await m("browser_console_messages",t.viewId);const e=await a.commands.executeCommand("cursor.browserView.getConsoleLogs",t.viewId);return{content:[{type:"text",text:JSON.stringify(e,null,2)}]}},async networkRequests(t){await m("browser_network_requests",t.viewId);const e=await a.commands.executeCommand("cursor.browserView.getNetworkRequests",t.viewId);return{content:[{type:"text",text:JSON.stringify(e,null,2)}]}},async takeScreenshot(t){await m("browser_take_screenshot",t.viewId);let e=t;if(t.filename&&!/\.[a-zA-Z0-9]+$/.test(t.filename)){const n=t.type||"png";e={...t,filename:`${t.filename}.${n}`}}const n=await a.commands.executeCommand("cursor.browserView.takeScreenshot",e);if(!n.success||n.error)return{content:[{type:"text",text:`Screenshot failed: ${n.error||"Unknown error"}`}]};if(n.dataUrl){const t=n.dataUrl.match(/^data:([^;]+);base64,(.+)$/);if(t){const e=t[1],r=t[2],s=["Screenshot captured successfully"];return n.filename&&s.push(`Filename: ${n.filename}`),n.savedPath&&s.push(`Saved to: ${n.savedPath}`),{content:[{type:"text",text:s.join("\n")},{type:"image",data:r,mimeType:e}]}}}return{content:[{type:"text",text:n.savedPath?`Screenshot saved to: ${n.savedPath}`:"Screenshot captured but no image data available"}]}},goBack:async t=>(await m("browser_navigate_back",t.viewId),await a.commands.executeCommand("cursor.browserView.goBack",t.viewId)?{content:[{type:"text",text:"Successfully navigated back"}]}:{content:[{type:"text",text:"Failed to navigate back"}]}),async resize(t){await m("browser_resize",t.viewId);const{success:e}=await a.commands.executeCommand("cursor.browserView.resize",{...t,viewId:t.viewId});return e?{content:[{type:"text",text:"Successfully resized browser"}]}:{content:[{type:"text",text:"Failed to resize browser"}]}},async tabs(t){switch(t.action){case"list":{const t=await a.commands.executeCommand("cursor.browserView.listTabs");return t&&t.tabs?{content:[{type:"text",text:`Open tabs:\n${(await Promise.all(t.tabs.map(async(t,e)=>`[${e}] (viewId: ${t}) ${await a.commands.executeCommand("cursor.browserView.getURL",t)||"about:blank"}`))).join("\n")}`}]}:{content:[{type:"text",text:"Open tabs:\n(none)"}]}}case"new":{const e=t.position?{position:t.position}:void 0;return await a.commands.executeCommand("cursor.browserView.newTab",void 0,e),{content:[{type:"text",text:"Created new tab"+("side"===t.position?" on the side":"")}]}}case"close":{const n=await a.commands.executeCommand("cursor.browserView.listTabs"),r=n?.tabs??[],s=void 0!==t.index?r[t.index]:void 0;await a.commands.executeCommand("cursor.browserView.closeTab",s);const o=await a.commands.executeCommand("cursor.browserView.listTabs"),i=o?.activeTab??o?.lastInteractedTab;return i?await e.BrowserTools.snapshot({viewId:i}):{content:[{type:"text",text:"Tab closed. No remaining tabs."}]}}case"select":{if(void 0===t.index)throw new Error("Tab index is required");const n=await a.commands.executeCommand("cursor.browserView.listTabs"),r=(n?.tabs??[])[t.index];if(!r)throw new Error(`Tab ${t.index} not found`);return await a.commands.executeCommand("cursor.browserView.selectTab",r),await e.BrowserTools.snapshot({viewId:r})}default:throw new Error(`Unknown action: ${t.action}`)}}}},756:(t,e)=>{Object.defineProperty(e,"__esModule",{value:!0}),e.generateBrowserUIScript=function(t){return`\n(function() {\n\t// Prevent double injection\n\tif (window.__cursorBrowserAutomationInjected) {\n\t\treturn;\n\t}\n\n\t// Only inject in top-level frame\n\tif (window !== window.top) {\n\t\treturn;\n\t}\n\n\twindow.__cursorBrowserAutomationInjected = true;\n\n\tconst tabId = ${JSON.stringify(t)};\n\n\t// =============================================================================\n\t// Area Screenshot Selection\n\t// =============================================================================\n\t// IMPORTANT: BrowserEditorContent.tsx may also inject area screenshot handling\n\t// via BROWSER_AREA_SCREENSHOT_SCRIPT. Check if it's already injected to avoid\n\t// duplicate screenshot captures.\n\n\tconst areaScreenshotAlreadyInjected = window.__cursorAreaScreenshotInjected === true;\n\n\tlet isDragging = false;\n\tlet dragStartX = null;\n\tlet dragStartY = null;\n\tlet dragSelectionBox = null;\n\tlet areaDragListeners = null;\n\n\tfunction enableAreaSelection() {\n\t\t// Skip if BrowserEditorContent already handles area screenshots\n\t\tif (areaScreenshotAlreadyInjected) {\n\t\t\treturn;\n\t\t}\n\n\t\tconst mousedownListener = (e) => {\n\t\t\t// Only start drag if not clicking on any overlay elements\n\t\t\tif (e.target.getAttribute &&\n\t\t\t\te.target.getAttribute('data-cursor-overlay') === 'true'\n\t\t\t) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\te.preventDefault();\n\t\t\te.stopPropagation();\n\n\t\t\tisDragging = true;\n\t\t\tdragStartX = e.clientX;\n\t\t\tdragStartY = e.clientY;\n\n\t\t\t// Hide any existing overlays\n\t\t\tconst overlays = document.querySelectorAll('[data-cursor-overlay="true"]');\n\t\t\toverlays.forEach(el => el.style.display = 'none');\n\n\t\t\tif (!dragSelectionBox) {\n\t\t\t\tdragSelectionBox = document.createElement('div');\n\t\t\t\tdragSelectionBox.style.cssText = 'position:fixed;background:rgba(58,150,221,0.1);border:2px dashed #3a96dd;pointer-events:none;z-index:2147483647;';\n\t\t\t\tdocument.body.appendChild(dragSelectionBox);\n\t\t\t}\n\t\t\tdragSelectionBox.style.left = dragStartX + 'px';\n\t\t\tdragSelectionBox.style.top = dragStartY + 'px';\n\t\t\tdragSelectionBox.style.width = '0px';\n\t\t\tdragSelectionBox.style.height = '0px';\n\t\t};\n\n\t\tconst mousemoveListener = (e) => {\n\t\t\tif (!isDragging || !dragSelectionBox) return;\n\n\t\t\tconst currentX = e.clientX;\n\t\t\tconst currentY = e.clientY;\n\n\t\t\tconst left = Math.min(dragStartX, currentX);\n\t\t\tconst top = Math.min(dragStartY, currentY);\n\t\t\tconst width = Math.abs(currentX - dragStartX);\n\t\t\tconst height = Math.abs(currentY - dragStartY);\n\n\t\t\tdragSelectionBox.style.left = left + 'px';\n\t\t\tdragSelectionBox.style.top = top + 'px';\n\t\t\tdragSelectionBox.style.width = width + 'px';\n\t\t\tdragSelectionBox.style.height = height + 'px';\n\t\t};\n\n\t\tconst mouseupListener = (e) => {\n\t\t\tif (!isDragging) return;\n\t\t\te.preventDefault();\n\t\t\te.stopPropagation();\n\n\t\t\tconst currentX = e.clientX;\n\t\t\tconst currentY = e.clientY;\n\n\t\t\tconst left = Math.min(dragStartX, currentX);\n\t\t\tconst top = Math.min(dragStartY, currentY);\n\t\t\tconst width = Math.abs(currentX - dragStartX);\n\t\t\tconst height = Math.abs(currentY - dragStartY);\n\n\t\t\tif (width > 5 || height > 5) {\n\t\t\t\tconst bounds = {\n\t\t\t\t\tx: Math.round(left),\n\t\t\t\t\ty: Math.round(top),\n\t\t\t\t\twidth: Math.round(width),\n\t\t\t\t\theight: Math.round(height)\n\t\t\t\t};\n\n\t\t\t\tif (dragSelectionBox) {\n\t\t\t\t\tdragSelectionBox.remove();\n\t\t\t\t\tdragSelectionBox = null;\n\t\t\t\t}\n\n\t\t\t\tdisableAreaSelection();\n\n\t\t\t\t// Send area screenshot selection\n\t\t\t\trequestAnimationFrame(() => {\n\t\t\t\t\trequestAnimationFrame(() => {\n\t\t\t\t\t\tif (window.cursorBrowser) {\n\t\t\t\t\t\t\twindow.cursorBrowser.send('area-screenshot-selected', {\n\t\t\t\t\t\t\t\tbounds: bounds\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// Area selection is complete, element selection will continue to work\n\t\t\t\t\t\t// No need to re-enable as the overlay system maintains its own state\n\t\t\t\t\t});\n\t\t\t\t});\n\t\t\t} else {\n\t\t\t\tif (dragSelectionBox) {\n\t\t\t\t\tdragSelectionBox.remove();\n\t\t\t\t\tdragSelectionBox = null;\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tisDragging = false;\n\t\t};\n\n\t\tdocument.addEventListener('mousedown', mousedownListener, true);\n\t\tdocument.addEventListener('mousemove', mousemoveListener);\n\t\tdocument.addEventListener('mouseup', mouseupListener, true);\n\n\t\tareaDragListeners = {\n\t\t\tmousedown: mousedownListener,\n\t\t\tmousemove: mousemoveListener,\n\t\t\tmouseup: mouseupListener\n\t\t};\n\t}\n\n\tfunction disableAreaSelection() {\n\t\t// Skip if BrowserEditorContent already handles area screenshots\n\t\tif (areaScreenshotAlreadyInjected) {\n\t\t\treturn;\n\t\t}\n\n\t\tisDragging = false;\n\t\tdragStartX = null;\n\t\tdragStartY = null;\n\n\t\tif (dragSelectionBox) {\n\t\t\tdragSelectionBox.remove();\n\t\t\tdragSelectionBox = null;\n\t\t}\n\n\t\tif (areaDragListeners) {\n\t\t\tconst { mousedown, mousemove, mouseup } = areaDragListeners;\n\t\t\tdocument.removeEventListener('mousedown', mousedown, true);\n\t\t\tdocument.removeEventListener('mousemove', mousemove);\n\t\t\tdocument.removeEventListener('mouseup', mouseup, true);\n\t\t\tareaDragListeners = null;\n\t\t}\n\t}\n\n\t// =============================================================================\n\t// Message Handling\n\t// =============================================================================\n\n\twindow.addEventListener('message', (e) => {\n\t\tif (e.data.type === 'enable-element-selection') {\n\t\t\t// Check if we should enable area selection along with element selection\n\t\t\tif (e.data.enableAreaSelection) {\n\t\t\t\tenableAreaSelection();\n\t\t\t}\n\t\t\t// Don't re-post the message - the overlay system will handle it directly\n\t\t} else if (e.data.type === 'disable-element-selection') {\n\t\t\tdisableAreaSelection();\n\t\t\t// Don't re-post the message - the overlay system will handle it directly\n\t\t} else if (e.data.type === 'start-area-screenshot') {\n\t\t\tenableAreaSelection();\n\t\t} else if (e.data.type === 'stop-area-screenshot') {\n\t\t\tdisableAreaSelection();\n\t\t}\n\t});\n\n\t// =============================================================================\n\t// Keyboard Shortcuts\n\t// =============================================================================\n\n\tdocument.addEventListener('keydown', (e) => {\n\t\tconst isMac = navigator.platform.toUpperCase().indexOf('MAC') >= 0;\n\t\tconst cmdOrCtrl = isMac ? e.metaKey : e.ctrlKey;\n\n\t\tif (cmdOrCtrl && !e.altKey) {\n\t\t\tif (e.key === 'a' && !e.shiftKey) {\n\t\t\t\te.preventDefault();\n\t\t\t\te.stopPropagation();\n\n\t\t\t\tconst target = e.target;\n\t\t\t\tif (target instanceof HTMLInputElement || target instanceof HTMLTextAreaElement) {\n\t\t\t\t\ttarget.select();\n\t\t\t\t} else if (target instanceof HTMLElement && target.isContentEditable) {\n\t\t\t\t\tconst selection = window.getSelection();\n\t\t\t\t\tconst range = document.createRange();\n\t\t\t\t\trange.selectNodeContents(target);\n\t\t\t\t\tselection?.removeAllRanges();\n\t\t\t\t\tselection?.addRange(range);\n\t\t\t\t} else {\n\t\t\t\t\tdocument.execCommand('selectAll');\n\t\t\t\t}\n\t\t\t\treturn;\n\t\t\t}\n\t\t}\n\t}, true);\n\n})();\n`}},857:t=>{t.exports=require("os")},928:t=>{t.exports=require("path")},943:t=>{t.exports=require("fs/promises")}},e={},n=function n(r){var s=e[r];if(void 0!==s)return s.exports;var o=e[r]={exports:{}};return t[r].call(o.exports,o,o.exports,n),o.exports}(256),r=exports;for(var s in n)r[s]=n[s];n.__esModule&&Object.defineProperty(r,"__esModule",{value:!0})})();
//# sourceMappingURL=http://go/sourcemap/sourcemaps/bb2dbaacf30bb7eb9fd48a37812a8f326defa530/extensions/cursor-browser-automation/dist/extension.js.map