Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

/**
 * Converts a string-based level into a `SeverityLevel`, normalizing it along the way.
 *
 * @param level String representation of desired `SeverityLevel`.
 * @returns The `SeverityLevel` corresponding to the given string, or 'log' if the string isn't a valid level.
 */
function severityLevelFromString(level) {
  return (
    level === 'warn' ? 'warning' : ['fatal', 'error', 'warning', 'log', 'info', 'debug'].includes(level) ? level : 'log'
  ) ;
}

exports.severityLevelFromString = severityLevelFromString;//# sourceMappingURL=http://go/sourcemap/sourcemaps/ba90f2f88e4911312761abab9492c42442117cf0/node_modules/@sentry/core/build/cjs/utils/severity.js.map
