const core = require('@sentry/core');
const scope = require('../../common/scope.js');
const ipc = require('../ipc.js');

/**
 * Passes scope changes to the main process.
 */
const scopeToMainIntegration = core.defineIntegration(() => {
    return {
        name: 'ScopeToMain',
        setup() {
            const ipc$1 = ipc.getIPC();
            scope.addScopeListener((merged, changed) => {
                ipc$1.sendScope(JSON.stringify(core.normalize(merged, 20, 2000)));
                changed.clearBreadcrumbs();
                changed.clearAttachments();
            });
        },
    };
});

exports.scopeToMainIntegration = scopeToMainIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/b753cece5c67c47cb5637199a5a5de2b7100c180/node_modules/@sentry/electron/renderer/integrations/scope-to-main.js.map
