const node = require('@sentry/node');
const electronBreadcrumbs = require('./integrations/electron-breadcrumbs.js');
const onuncaughtexception = require('./integrations/onuncaughtexception.js');
const index = require('./integrations/sentry-minidump/index.js');
const electronMinidump = require('./integrations/electron-minidump.js');
const preloadInjection = require('./integrations/preload-injection.js');
const mainProcessSession = require('./integrations/main-process-session.js');
const browserWindowSession = require('./integrations/browser-window-session.js');
const additionalContext = require('./integrations/additional-context.js');
const netBreadcrumbs = require('./integrations/net-breadcrumbs.js');
const childProcess = require('./integrations/child-process.js');
const screenshots = require('./integrations/screenshots.js');
const rendererProfiling = require('./integrations/renderer-profiling.js');
const normalizePaths = require('./integrations/normalize-paths.js');
const electronContext = require('./integrations/electron-context.js');
const gpuContext = require('./integrations/gpu-context.js');
const anr = require('./integrations/anr.js');
const rendererAnr = require('./integrations/renderer-anr.js');
const electronNet = require('./transports/electron-net.js');
const electronOfflineNet = require('./transports/electron-offline-net.js');
const sdk = require('./sdk.js');
const stackParse = require('./stack-parse.js');
const ipc = require('../common/ipc.js');



exports.NodeClient = node.NodeClient;
exports.OpenFeatureIntegrationHook = node.OpenFeatureIntegrationHook;
exports.SEMANTIC_ATTRIBUTE_SENTRY_OP = node.SEMANTIC_ATTRIBUTE_SENTRY_OP;
exports.SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN = node.SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN;
exports.SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE = node.SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE;
exports.SEMANTIC_ATTRIBUTE_SENTRY_SOURCE = node.SEMANTIC_ATTRIBUTE_SENTRY_SOURCE;
exports.Scope = node.Scope;
exports.SentryContextManager = node.SentryContextManager;
exports.addBreadcrumb = node.addBreadcrumb;
exports.addEventProcessor = node.addEventProcessor;
exports.addIntegration = node.addIntegration;
exports.amqplibIntegration = node.amqplibIntegration;
exports.buildLaunchDarklyFlagUsedHandler = node.buildLaunchDarklyFlagUsedHandler;
exports.captureCheckIn = node.captureCheckIn;
exports.captureConsoleIntegration = node.captureConsoleIntegration;
exports.captureEvent = node.captureEvent;
exports.captureException = node.captureException;
exports.captureFeedback = node.captureFeedback;
exports.captureMessage = node.captureMessage;
exports.captureSession = node.captureSession;
exports.close = node.close;
exports.connectIntegration = node.connectIntegration;
exports.consoleIntegration = node.consoleIntegration;
exports.consoleLoggingIntegration = node.consoleLoggingIntegration;
exports.contextLinesIntegration = node.contextLinesIntegration;
exports.continueTrace = node.continueTrace;
exports.createGetModuleFromFilename = node.createGetModuleFromFilename;
exports.createSentryWinstonTransport = node.createSentryWinstonTransport;
exports.createTransport = node.createTransport;
exports.cron = node.cron;
exports.dataloaderIntegration = node.dataloaderIntegration;
exports.dedupeIntegration = node.dedupeIntegration;
exports.disableAnrDetectionForCallback = node.disableAnrDetectionForCallback;
exports.endSession = node.endSession;
exports.eventFiltersIntegration = node.eventFiltersIntegration;
exports.expressErrorHandler = node.expressErrorHandler;
exports.expressIntegration = node.expressIntegration;
exports.extraErrorDataIntegration = node.extraErrorDataIntegration;
exports.fastifyIntegration = node.fastifyIntegration;
exports.featureFlagsIntegration = node.featureFlagsIntegration;
exports.flush = node.flush;
exports.fsIntegration = node.fsIntegration;
exports.functionToStringIntegration = node.functionToStringIntegration;
exports.generateInstrumentOnce = node.generateInstrumentOnce;
exports.genericPoolIntegration = node.genericPoolIntegration;
exports.getActiveSpan = node.getActiveSpan;
exports.getAutoPerformanceIntegrations = node.getAutoPerformanceIntegrations;
exports.getClient = node.getClient;
exports.getCurrentScope = node.getCurrentScope;
exports.getGlobalScope = node.getGlobalScope;
exports.getIsolationScope = node.getIsolationScope;
exports.getRootSpan = node.getRootSpan;
exports.getSpanDescendants = node.getSpanDescendants;
exports.getSpanStatusFromHttpCode = node.getSpanStatusFromHttpCode;
exports.getTraceData = node.getTraceData;
exports.getTraceMetaTags = node.getTraceMetaTags;
exports.graphqlIntegration = node.graphqlIntegration;
exports.hapiIntegration = node.hapiIntegration;
exports.httpIntegration = node.httpIntegration;
exports.inboundFiltersIntegration = node.inboundFiltersIntegration;
exports.initOpenTelemetry = node.initOpenTelemetry;
exports.instrumentSupabaseClient = node.instrumentSupabaseClient;
exports.isEnabled = node.isEnabled;
exports.isInitialized = node.isInitialized;
exports.kafkaIntegration = node.kafkaIntegration;
exports.knexIntegration = node.knexIntegration;
exports.koaIntegration = node.koaIntegration;
exports.lastEventId = node.lastEventId;
exports.launchDarklyIntegration = node.launchDarklyIntegration;
exports.linkedErrorsIntegration = node.linkedErrorsIntegration;
exports.localVariablesIntegration = node.localVariablesIntegration;
exports.logger = node.logger;
exports.lruMemoizerIntegration = node.lruMemoizerIntegration;
exports.modulesIntegration = node.modulesIntegration;
exports.mongoIntegration = node.mongoIntegration;
exports.mongooseIntegration = node.mongooseIntegration;
exports.mysql2Integration = node.mysql2Integration;
exports.mysqlIntegration = node.mysqlIntegration;
exports.nativeNodeFetchIntegration = node.nativeNodeFetchIntegration;
exports.nodeContextIntegration = node.nodeContextIntegration;
exports.onUnhandledRejectionIntegration = node.onUnhandledRejectionIntegration;
exports.openAIIntegration = node.openAIIntegration;
exports.openFeatureIntegration = node.openFeatureIntegration;
exports.parameterize = node.parameterize;
exports.postgresIntegration = node.postgresIntegration;
exports.postgresJsIntegration = node.postgresJsIntegration;
exports.prismaIntegration = node.prismaIntegration;
exports.profiler = node.profiler;
exports.redisIntegration = node.redisIntegration;
exports.requestDataIntegration = node.requestDataIntegration;
exports.rewriteFramesIntegration = node.rewriteFramesIntegration;
exports.setContext = node.setContext;
exports.setCurrentClient = node.setCurrentClient;
exports.setExtra = node.setExtra;
exports.setExtras = node.setExtras;
exports.setHttpStatus = node.setHttpStatus;
exports.setMeasurement = node.setMeasurement;
exports.setNodeAsyncContextStrategy = node.setNodeAsyncContextStrategy;
exports.setTag = node.setTag;
exports.setTags = node.setTags;
exports.setUser = node.setUser;
exports.setupConnectErrorHandler = node.setupConnectErrorHandler;
exports.setupExpressErrorHandler = node.setupExpressErrorHandler;
exports.setupFastifyErrorHandler = node.setupFastifyErrorHandler;
exports.setupHapiErrorHandler = node.setupHapiErrorHandler;
exports.setupKoaErrorHandler = node.setupKoaErrorHandler;
exports.spanToBaggageHeader = node.spanToBaggageHeader;
exports.spanToJSON = node.spanToJSON;
exports.spanToTraceHeader = node.spanToTraceHeader;
exports.spotlightIntegration = node.spotlightIntegration;
exports.startInactiveSpan = node.startInactiveSpan;
exports.startNewTrace = node.startNewTrace;
exports.startSession = node.startSession;
exports.startSpan = node.startSpan;
exports.startSpanManual = node.startSpanManual;
exports.statsigIntegration = node.statsigIntegration;
exports.supabaseIntegration = node.supabaseIntegration;
exports.suppressTracing = node.suppressTracing;
exports.tediousIntegration = node.tediousIntegration;
exports.trpcMiddleware = node.trpcMiddleware;
exports.unleashIntegration = node.unleashIntegration;
exports.updateSpanName = node.updateSpanName;
exports.validateOpenTelemetrySetup = node.validateOpenTelemetrySetup;
exports.withActiveSpan = node.withActiveSpan;
exports.withIsolationScope = node.withIsolationScope;
exports.withMonitor = node.withMonitor;
exports.withScope = node.withScope;
exports.wrapMcpServerWithSentry = node.wrapMcpServerWithSentry;
exports.zodErrorsIntegration = node.zodErrorsIntegration;
exports.electronBreadcrumbsIntegration = electronBreadcrumbs.electronBreadcrumbsIntegration;
exports.onUncaughtExceptionIntegration = onuncaughtexception.onUncaughtExceptionIntegration;
exports.sentryMinidumpIntegration = index.sentryMinidumpIntegration;
exports.electronMinidumpIntegration = electronMinidump.electronMinidumpIntegration;
exports.preloadInjectionIntegration = preloadInjection.preloadInjectionIntegration;
exports.mainProcessSessionIntegration = mainProcessSession.mainProcessSessionIntegration;
exports.browserWindowSessionIntegration = browserWindowSession.browserWindowSessionIntegration;
exports.additionalContextIntegration = additionalContext.additionalContextIntegration;
exports.electronNetIntegration = netBreadcrumbs.electronNetIntegration;
exports.childProcessIntegration = childProcess.childProcessIntegration;
exports.screenshotsIntegration = screenshots.screenshotsIntegration;
exports.rendererProfileFromIpc = rendererProfiling.rendererProfileFromIpc;
exports.normalizePathsIntegration = normalizePaths.normalizePathsIntegration;
exports.electronContextIntegration = electronContext.electronContextIntegration;
exports.gpuContextIntegration = gpuContext.gpuContextIntegration;
exports.anrIntegration = anr.anrIntegration;
exports.rendererAnrIntegration = rendererAnr.rendererAnrIntegration;
exports.makeElectronTransport = electronNet.makeElectronTransport;
exports.makeElectronOfflineTransport = electronOfflineNet.makeElectronOfflineTransport;
exports.getDefaultIntegrations = sdk.getDefaultIntegrations;
exports.init = sdk.init;
exports.defaultStackParser = stackParse.defaultStackParser;
Object.defineProperty(exports, "IPCMode", {
	enumerable: true,
	get: () => ipc.IPCMode
});//# sourceMappingURL=http://go/sourcemap/sourcemaps/b753cece5c67c47cb5637199a5a5de2b7100c180/node_modules/@sentry/electron/main/index.js.map
