const core = require('@sentry/core');
const electron = require('electron');
const normalize = require('../normalize.js');

const normalizePathsIntegration = core.defineIntegration(() => {
    return {
        name: 'NormalizePaths',
        setup: (client) => {
            // We want this hook to be registered after the profiling-node hook so we can normalise the profile after it's
            // been attached
            setImmediate(() => {
                client.on('beforeEnvelope', (envelope) => {
                    core.forEachEnvelopeItem(envelope, (item, type) => {
                        if (type === 'profile') {
                            normalize.normaliseProfile(item[1], electron.app.getAppPath());
                        }
                    });
                });
            });
        },
        processEvent(event) {
            return normalize.normalizePaths(event, electron.app.getAppPath());
        },
    };
});

exports.normalizePathsIntegration = normalizePathsIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/b753cece5c67c47cb5637199a5a5de2b7100c180/node_modules/@sentry/electron/main/integrations/normalize-paths.js.map
