function addHeader(responseHeaders = {}, name, value) {
    if (responseHeaders[name]) {
        const existing = responseHeaders[name];
        if (Array.isArray(existing)) {
            existing.push(value);
        }
        else {
            responseHeaders[name] = [existing, value];
        }
    }
    else {
        responseHeaders[name] = value;
    }
    return { responseHeaders };
}
/**
 * Adds a header to a session's web request
 */
function addHeaderToSession(sesh, header, value) {
    sesh.webRequest.onHeadersReceived((details, callback) => {
        callback(addHeader(details.responseHeaders, header, value));
    });
}

exports.addHeaderToSession = addHeaderToSession;//# sourceMappingURL=http://go/sourcemap/sourcemaps/b753cece5c67c47cb5637199a5a5de2b7100c180/node_modules/@sentry/electron/main/header-injection.js.map
