import { defineIntegration } from '@sentry/core';
import { startSession, endSessionOnExit } from '../sessions.js';

/** Tracks sessions as the main process lifetime. */
const mainProcessSessionIntegration = defineIntegration((options = {}) => {
    return {
        name: 'MainProcessSession',
        setup() {
            startSession(!!options.sendOnCreate);
            endSessionOnExit();
        },
    };
});

export { mainProcessSessionIntegration };//# sourceMappingURL=http://go/sourcemap/sourcemaps/b6e8aa9d472272da33220f2c22aaef5086384030/node_modules/@sentry/electron/esm/main/integrations/main-process-session.js.map
