import { Observable, operate } from '../Observable.js';
export function pairwise() {
    return (source) => new Observable((destination) => {
        let prev;
        let hasPrev = false;
        source.subscribe(operate({
            destination,
            next: (value) => {
                const p = prev;
                prev = value;
                hasPrev && destination.next([p, value]);
                hasPrev = true;
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/b3e9fe6c37659159fc2dec9ae643d74c25e5d0d0/node_modules/rxjs/dist/esm/internal/operators/pairwise.js.map