import { Observable, operate, from } from '../Observable.js';
import { noop } from '../util/noop.js';
export function skipUntil(notifier) {
    return (source) => new Observable((destination) => {
        let taking = false;
        const skipSubscriber = operate({
            destination,
            next: () => {
                skipSubscriber?.unsubscribe();
                taking = true;
            },
            complete: noop,
        });
        from(notifier).subscribe(skipSubscriber);
        source.subscribe(operate({ destination, next: (value) => taking && destination.next(value) }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/b3c95a7981bb3057526f1f865e8c307a9911ce00/node_modules/rxjs/dist/esm/internal/operators/skipUntil.js.map