import { asyncScheduler } from '../scheduler/async.js';
import { Observable, operate } from '../Observable.js';
export function timeInterval(scheduler = asyncScheduler) {
    return (source) => new Observable((destination) => {
        let last = scheduler.now();
        source.subscribe(operate({
            destination,
            next: (value) => {
                const now = scheduler.now();
                const interval = now - last;
                last = now;
                destination.next(new TimeInterval(value, interval));
            },
        }));
    });
}
export class TimeInterval {
    value;
    interval;
    constructor(value, interval) {
        this.value = value;
        this.interval = interval;
    }
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/af6d64e4848e6185e482a2de5bac040191c8d790/node_modules/rxjs/dist/esm/internal/operators/timeInterval.js.map