"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.timeoutWith = void 0;
const async_js_1 = require("../scheduler/async.js");
const isDate_js_1 = require("../util/isDate.js");
const timeout_js_1 = require("./timeout.js");
function timeoutWith(due, withObservable, scheduler) {
    let first;
    let each;
    let _with;
    scheduler = scheduler ?? async_js_1.asyncScheduler;
    if ((0, isDate_js_1.isValidDate)(due)) {
        first = due;
    }
    else if (typeof due === 'number') {
        each = due;
    }
    if (withObservable) {
        _with = () => withObservable;
    }
    else {
        throw new TypeError('No observable provided to switch to');
    }
    if (first == null && each == null) {
        throw new TypeError('No timeout provided.');
    }
    return (0, timeout_js_1.timeout)({
        first,
        each,
        scheduler,
        with: _with,
    });
}
exports.timeoutWith = timeoutWith;//# sourceMappingURL=http://go/sourcemap/sourcemaps/af6d64e4848e6185e482a2de5bac040191c8d790/node_modules/rxjs/dist/cjs/internal/operators/timeoutWith.js.map