Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const carrier = require('./carrier.js');
const scope = require('./scope.js');

/** Get the default current scope. */
function getDefaultCurrentScope() {
  return carrier.getGlobalSingleton('defaultCurrentScope', () => new scope.Scope());
}

/** Get the default isolation scope. */
function getDefaultIsolationScope() {
  return carrier.getGlobalSingleton('defaultIsolationScope', () => new scope.Scope());
}

exports.getDefaultCurrentScope = getDefaultCurrentScope;
exports.getDefaultIsolationScope = getDefaultIsolationScope;//# sourceMappingURL=http://go/sourcemap/sourcemaps/af6d64e4848e6185e482a2de5bac040191c8d790/node_modules/@sentry/core/build/cjs/defaultScopes.js.map
