"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ColdObservable = void 0;
const Observable_js_1 = require("../Observable.js");
const Notification_js_1 = require("../Notification.js");
const subscription_logging_js_1 = require("./subscription-logging.js");
class ColdObservable extends Observable_js_1.Observable {
    messages;
    scheduler;
    subscriptions = [];
    logSubscribedFrame = subscription_logging_js_1.logSubscribedFrame;
    logUnsubscribedFrame = subscription_logging_js_1.logUnsubscribedFrame;
    _subscribe(subscriber) {
        const index = this.logSubscribedFrame();
        const subscription = new Observable_js_1.Subscription();
        subscription.add(new Observable_js_1.Subscription(() => {
            this.logUnsubscribedFrame(index);
        }));
        this.scheduleMessages(subscriber);
        return subscription;
    }
    constructor(messages, scheduler) {
        super();
        this.messages = messages;
        this.scheduler = scheduler;
    }
    scheduleMessages(subscriber) {
        const messagesLength = this.messages.length;
        for (let i = 0; i < messagesLength; i++) {
            const message = this.messages[i];
            subscriber.add(this.scheduler.schedule((state) => {
                const { message: { notification }, subscriber: destination, } = state;
                (0, Notification_js_1.observeNotification)(notification, destination);
            }, message.frame, { message, subscriber }));
        }
    }
}
exports.ColdObservable = ColdObservable;//# sourceMappingURL=http://go/sourcemap/sourcemaps/acdb5a1ab634f13d3d9381161dcb9603f184e670/node_modules/rxjs/dist/cjs/internal/testing/ColdObservable.js.map