import { Observable, operate } from '../Observable.js';
export function find(predicate) {
    return (source) => new Observable((subscriber) => createFind(predicate, 'value', source, subscriber));
}
export function createFind(predicate, emit, source, destination) {
    const findIndex = emit === 'index';
    let index = 0;
    source.subscribe(operate({
        destination,
        next: (value) => {
            const i = index++;
            if (predicate(value, i, source)) {
                destination.next(findIndex ? i : value);
                destination.complete();
            }
        },
        complete: () => {
            destination.next(findIndex ? -1 : undefined);
            destination.complete();
        },
    }));
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/acdb5a1ab634f13d3d9381161dcb9603f184e670/node_modules/rxjs/dist/esm/internal/operators/find.js.map