"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.catchError = void 0;
const Observable_js_1 = require("../Observable.js");
function catchError(selector) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let innerSub = null;
        let syncUnsub = false;
        let handledResult;
        innerSub = source.subscribe((0, Observable_js_1.operate)({
            destination,
            error: (err) => {
                handledResult = (0, Observable_js_1.from)(selector(err, catchError(selector)(source)));
                if (innerSub) {
                    innerSub.unsubscribe();
                    innerSub = null;
                    handledResult.subscribe(destination);
                }
                else {
                    syncUnsub = true;
                }
            },
        }));
        if (syncUnsub) {
            innerSub.unsubscribe();
            innerSub = null;
            handledResult.subscribe(destination);
        }
    });
}
exports.catchError = catchError;//# sourceMappingURL=http://go/sourcemap/sourcemaps/acdb5a1ab634f13d3d9381161dcb9603f184e670/node_modules/rxjs/dist/cjs/internal/operators/catchError.js.map