"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.timer = void 0;
const Observable_js_1 = require("../Observable.js");
const async_js_1 = require("../scheduler/async.js");
const isScheduler_js_1 = require("../util/isScheduler.js");
const isDate_js_1 = require("../util/isDate.js");
const executeSchedule_js_1 = require("../util/executeSchedule.js");
function timer(dueTime = 0, intervalOrScheduler, scheduler = async_js_1.asyncScheduler) {
    let intervalDuration = -1;
    if (intervalOrScheduler != null) {
        if ((0, isScheduler_js_1.isScheduler)(intervalOrScheduler)) {
            scheduler = intervalOrScheduler;
        }
        else {
            intervalDuration = intervalOrScheduler;
        }
    }
    return new Observable_js_1.Observable((subscriber) => {
        let due = (0, isDate_js_1.isValidDate)(dueTime) ? +dueTime - scheduler.now() : dueTime;
        if (due < 0) {
            due = 0;
        }
        let n = 0;
        return (0, executeSchedule_js_1.executeSchedule)(subscriber, scheduler, () => {
            subscriber.next(n++);
            if (0 <= intervalDuration) {
                (0, executeSchedule_js_1.executeSchedule)(subscriber, scheduler, () => {
                    subscriber.next(n++);
                }, intervalDuration, true);
            }
            else {
                subscriber.complete();
            }
        }, due);
    });
}
exports.timer = timer;//# sourceMappingURL=http://go/sourcemap/sourcemaps/ac32b095dae9b8e0cfede6c5ebc55e589ee50e10/node_modules/rxjs/dist/cjs/internal/observable/timer.js.map