"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pairwise = void 0;
const Observable_js_1 = require("../Observable.js");
function pairwise() {
    return (source) => new Observable_js_1.Observable((destination) => {
        let prev;
        let hasPrev = false;
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                const p = prev;
                prev = value;
                hasPrev && destination.next([p, value]);
                hasPrev = true;
            },
        }));
    });
}
exports.pairwise = pairwise;//# sourceMappingURL=http://go/sourcemap/sourcemaps/ac32b095dae9b8e0cfede6c5ebc55e589ee50e10/node_modules/rxjs/dist/cjs/internal/operators/pairwise.js.map