import crypto from 'crypto';
import { coerce } from '../bytes.js';
import { from } from './hasher.js';
export const sha256 = from({
    name: 'sha2-256',
    code: 0x12,
    encode: (input) => coerce(crypto.createHash('sha256').update(input).digest())
});
export const sha512 = from({
    name: 'sha2-512',
    code: 0x13,
    encode: input => coerce(crypto.createHash('sha512').update(input).digest())
});//# sourceMappingURL=http://go/sourcemap/sourcemaps/ac32b095dae9b8e0cfede6c5ebc55e589ee50e10/node_modules/multiformats/dist/src/hashes/sha2.js.map