import { defineIntegration } from '@sentry/core';
import { getIPC } from '../ipc.js';

const eventLoopBlockIntegration = defineIntegration((options) => {
    const anrThreshold = options?.threshold ?? 1000;
    const pollInterval = options?.pollInterval || anrThreshold / 2;
    return {
        name: 'EventLoopBlockRenderer',
        setup() {
            const config = {
                pollInterval,
                anrThreshold,
                captureStackTrace: true,
                ...options,
            };
            const ipc = getIPC();
            // eslint-disable-next-line no-restricted-globals
            ipc.sendStatus({ status: document.visibilityState, config });
            setInterval(() => {
                ipc.sendStatus({ status: 'alive', config });
            }, config.pollInterval);
        },
    };
});

export { eventLoopBlockIntegration };//# sourceMappingURL=http://go/sourcemap/sourcemaps/a9b73428ca6aeb2d24623da2841a271543735560/node_modules/@sentry/electron/esm/renderer/integrations/event-loop-block.js.map
