import { app } from 'electron';
import { SDK_VERSION } from './version.js';

const SDK_NAME = 'sentry.javascript.electron';
/** Gets SDK info */
function getSdkInfo() {
    return {
        name: SDK_NAME,
        packages: [
            {
                name: 'npm:@sentry/electron',
                version: SDK_VERSION,
            },
        ],
        version: SDK_VERSION,
    };
}
/** Gets the default release name */
function getDefaultReleaseName() {
    const app_name = app.name || app.getName();
    return `${app_name.replace(/\W/g, '-')}@${app.getVersion()}`;
}
/** Gets the default environment */
function getDefaultEnvironment() {
    return app.isPackaged ? 'production' : 'development';
}
/**
 * Gets the default event data by calling all event processors.
 */
async function getEventDefaults(client) {
    let event = { message: 'test' };
    const eventHint = {};
    for (const processor of client.getEventProcessors()) {
        if (event === null)
            break;
        event = await processor(event, eventHint);
    }
    delete event?.message;
    return event || {};
}

export { SDK_NAME, getDefaultEnvironment, getDefaultReleaseName, getEventDefaults, getSdkInfo };//# sourceMappingURL=http://go/sourcemap/sourcemaps/a9b73428ca6aeb2d24623da2841a271543735560/node_modules/@sentry/electron/esm/main/context.js.map
