import { identity } from '../util/identity.js';
import { Observable, operate } from '../Observable.js';
export function distinctUntilChanged(comparator, keySelector = identity) {
    comparator = comparator ?? defaultCompare;
    return (source) => new Observable((destination) => {
        let previousKey;
        let first = true;
        source.subscribe(operate({
            destination,
            next: (value) => {
                const currentKey = keySelector(value);
                if (first || !comparator(previousKey, currentKey)) {
                    first = false;
                    previousKey = currentKey;
                    destination.next(value);
                }
            },
        }));
    });
}
function defaultCompare(a, b) {
    return a === b;
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/a8d8905b06c8da1739af6f789efd59c28ac2a680/node_modules/rxjs/dist/esm/internal/operators/distinctUntilChanged.js.map