const core = require('@sentry/core');
const scope = require('../../common/scope.js');
const ipc = require('../ipc.js');

/**
 * Passes scope changes to the main process.
 */
const scopeToMainIntegration = core.defineIntegration(() => {
    return {
        name: 'ScopeToMain',
        setup(client) {
            const ipc$1 = ipc.getIPC(client);
            scope.addScopeListener((merged, changed) => {
                ipc$1.sendScope(JSON.stringify(core.normalize(merged, 20, 2000)));
                changed.clearBreadcrumbs();
                changed.clearAttachments();
            });
        },
    };
});

exports.scopeToMainIntegration = scopeToMainIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/a8d8905b06c8da1739af6f789efd59c28ac2a680/node_modules/@sentry/electron/renderer/integrations/scope-to-main.js.map
