"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AjaxTimeoutError = exports.AjaxError = void 0;
class AjaxError extends Error {
    xhr;
    request;
    status;
    responseType;
    response;
    constructor(message, xhr, request) {
        super(message);
        this.name = 'AjaxError';
        this.xhr = xhr;
        this.request = request;
        this.status = xhr.status;
        this.responseType = xhr.responseType;
        this.response = xhr.response;
    }
}
exports.AjaxError = AjaxError;
class AjaxTimeoutError extends AjaxError {
    constructor(xhr, request) {
        super('ajax timeout', xhr, request);
        this.name = 'AjaxTimeoutError';
    }
}
exports.AjaxTimeoutError = AjaxTimeoutError;//# sourceMappingURL=http://go/sourcemap/sourcemaps/a86689c93e9fb11addfbefd29a6ec7c0a59175e0/node_modules/rxjs/dist/cjs/internal/ajax/errors.js.map