"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFind = exports.find = void 0;
const Observable_js_1 = require("../Observable.js");
function find(predicate) {
    return (source) => new Observable_js_1.Observable((subscriber) => createFind(predicate, 'value', source, subscriber));
}
exports.find = find;
function createFind(predicate, emit, source, destination) {
    const findIndex = emit === 'index';
    let index = 0;
    source.subscribe((0, Observable_js_1.operate)({
        destination,
        next: (value) => {
            const i = index++;
            if (predicate(value, i, source)) {
                destination.next(findIndex ? i : value);
                destination.complete();
            }
        },
        complete: () => {
            destination.next(findIndex ? -1 : undefined);
            destination.complete();
        },
    }));
}
exports.createFind = createFind;//# sourceMappingURL=http://go/sourcemap/sourcemaps/a86689c93e9fb11addfbefd29a6ec7c0a59175e0/node_modules/rxjs/dist/cjs/internal/operators/find.js.map