const core = require('@sentry/core');

/** Gets the merged scope data */
function getScopeData() {
    const globalScope = core.getGlobalScope().getScopeData();
    const isolationScope = core.getIsolationScope().getScopeData();
    const currentScope = core.getCurrentScope().getScopeData();
    core.mergeScopeData(globalScope, isolationScope);
    core.mergeScopeData(globalScope, currentScope);
    globalScope.eventProcessors = [];
    return globalScope;
}
/** Hooks both current and isolation scope changes and passes merged scope on changes  */
function addScopeListener(callback) {
    core.getIsolationScope().addScopeListener((isolation) => {
        const merged = getScopeData();
        callback(merged, isolation);
    });
    core.getCurrentScope().addScopeListener((current) => {
        const merged = getScopeData();
        callback(merged, current);
    });
    core.getGlobalScope().addScopeListener((global) => {
        const merged = getScopeData();
        callback(merged, global);
    });
}

exports.addScopeListener = addScopeListener;
exports.getScopeData = getScopeData;//# sourceMappingURL=http://go/sourcemap/sourcemaps/a86689c93e9fb11addfbefd29a6ec7c0a59175e0/node_modules/@sentry/electron/common/scope.js.map
