// This code was originally copied from  https://github.com/DirtyHairy/async-mutex
// before being significantly simplified for our usage
//
// Copied at commit: 3d2d987e60799d0fa222f1df8f99fc90ed570bfd
// Original licence:
/** An async mutex that queues up tasks for a shared resource */
class Mutex {
    constructor() {
        this._entries = [];
        this._waiters = [];
        this._value = 1;
    }
    /** Run a task when all pending tasks are complete */
    async runExclusive(task) {
        const release = await this._acquire();
        try {
            return await task();
        }
        finally {
            release();
        }
    }
    /** Gets a promise that resolves when all pending tasks are complete */
    _acquire() {
        return new Promise((resolve, reject) => {
            this._entries.push({ resolve, reject });
            this._dispatch();
        });
    }
    /** Releases after a task is complete */
    _release() {
        this._value += 1;
        this._dispatch();
    }
    /** Dispatches pending tasks */
    _dispatch() {
        for (let weight = this._value; weight > 0; weight--) {
            const queueEntry = this._entries?.shift();
            if (!queueEntry)
                continue;
            this._value -= weight;
            weight = this._value + 1;
            queueEntry.resolve(this._newReleaser());
        }
        this._drainUnlockWaiters();
    }
    /** Creates a new releaser */
    _newReleaser() {
        let called = false;
        return () => {
            if (called)
                return;
            called = true;
            this._release();
        };
    }
    /** Drain unlock waiters */
    _drainUnlockWaiters() {
        for (let weight = this._value; weight > 0; weight--) {
            if (!this._waiters[weight - 1])
                continue;
            this._waiters.forEach((waiter) => waiter());
            this._waiters = [];
        }
    }
}

exports.Mutex = Mutex;//# sourceMappingURL=http://go/sourcemap/sourcemaps/a84f941711ad680a635c8a3456002833186c4840/node_modules/@sentry/electron/main/mutex.js.map
