const core = require('@sentry/core');

/** Gets the merged scope data */
function getScopeData() {
    const globalScope = core.getGlobalScope().getScopeData();
    const isolationScope = core.getIsolationScope().getScopeData();
    const currentScope = core.getCurrentScope().getScopeData();
    core.mergeScopeData(globalScope, isolationScope);
    core.mergeScopeData(globalScope, currentScope);
    globalScope.eventProcessors = [];
    return globalScope;
}
/** Hooks both current and isolation scope changes and passes merged scope on changes  */
function addScopeListener(callback) {
    core.getIsolationScope().addScopeListener((isolation) => {
        const merged = getScopeData();
        callback(merged, isolation);
    });
    core.getCurrentScope().addScopeListener((current) => {
        const merged = getScopeData();
        callback(merged, current);
    });
    core.getGlobalScope().addScopeListener((global) => {
        const merged = getScopeData();
        callback(merged, global);
    });
}

exports.addScopeListener = addScopeListener;
exports.getScopeData = getScopeData;//# sourceMappingURL=http://go/sourcemap/sourcemaps/a788ca5efbb89cf7c24e873ea3623b2e47b42490/node_modules/@sentry/electron/common/scope.js.map
