import { Observable, operate } from '../Observable.js';
export function defaultIfEmpty(defaultValue) {
    return (source) => new Observable((destination) => {
        let hasValue = false;
        source.subscribe(operate({
            destination,
            next: (value) => {
                hasValue = true;
                destination.next(value);
            },
            complete: () => {
                if (!hasValue) {
                    destination.next(defaultValue);
                }
                destination.complete();
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/a022145cbf8aea0babc3b039a98551c1518de020/node_modules/rxjs/dist/esm/internal/operators/defaultIfEmpty.js.map