"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.observeOn = void 0;
const executeSchedule_js_1 = require("../util/executeSchedule.js");
const Observable_js_1 = require("../Observable.js");
function observeOn(scheduler, delay = 0) {
    return (source) => new Observable_js_1.Observable((destination) => {
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => (0, executeSchedule_js_1.executeSchedule)(destination, scheduler, () => destination.next(value), delay),
            error: (err) => (0, executeSchedule_js_1.executeSchedule)(destination, scheduler, () => destination.error(err), delay),
            complete: () => (0, executeSchedule_js_1.executeSchedule)(destination, scheduler, () => destination.complete(), delay),
        }));
    });
}
exports.observeOn = observeOn;//# sourceMappingURL=http://go/sourcemap/sourcemaps/a022145cbf8aea0babc3b039a98551c1518de020/node_modules/rxjs/dist/cjs/internal/operators/observeOn.js.map