"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AjaxTimeoutError = exports.AjaxError = void 0;
class AjaxError extends Error {
    xhr;
    request;
    status;
    responseType;
    response;
    constructor(message, xhr, request) {
        super(message);
        this.name = 'AjaxError';
        this.xhr = xhr;
        this.request = request;
        this.status = xhr.status;
        this.responseType = xhr.responseType;
        this.response = xhr.response;
    }
}
exports.AjaxError = AjaxError;
class AjaxTimeoutError extends AjaxError {
    constructor(xhr, request) {
        super('ajax timeout', xhr, request);
        this.name = 'AjaxTimeoutError';
    }
}
exports.AjaxTimeoutError = AjaxTimeoutError;//# sourceMappingURL=http://go/sourcemap/sourcemaps/a022145cbf8aea0babc3b039a98551c1518de020/node_modules/rxjs/dist/cjs/internal/ajax/errors.js.map