import { AsyncScheduler } from './AsyncScheduler.js';
export class AsapScheduler extends AsyncScheduler {
    flush(action) {
        this._active = true;
        const flushId = this._scheduled;
        this._scheduled = undefined;
        const { actions } = this;
        let error;
        action = action || actions.shift();
        do {
            if ((error = action.execute(action.state, action.delay))) {
                break;
            }
        } while ((action = actions[0]) && action.id === flushId && actions.shift());
        this._active = false;
        if (error) {
            while ((action = actions[0]) && action.id === flushId && actions.shift()) {
                action.unsubscribe();
            }
            throw error;
        }
    }
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/9cd7c8b6cebcbccc1242df211dee45a4b6fe15e0/node_modules/rxjs/dist/esm/internal/scheduler/AsapScheduler.js.map