Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

let cachedDebuggerEnabled;

/**
 * Was the debugger enabled when this function was first called?
 */
async function isDebuggerEnabled() {
  if (cachedDebuggerEnabled === undefined) {
    try {
      // Node can be built without inspector support
      const inspector = await import('node:inspector');
      cachedDebuggerEnabled = !!inspector.url();
    } catch {
      cachedDebuggerEnabled = false;
    }
  }

  return cachedDebuggerEnabled;
}

exports.isDebuggerEnabled = isDebuggerEnabled;//# sourceMappingURL=http://go/sourcemap/sourcemaps/9b5f3f4f2368631e3455d37672ca61b6dce85430/node_modules/@sentry/node-core/build/cjs/utils/debug.js.map
