const core = require('@sentry/core');
const ipc = require('../ipc.js');

const eventLoopBlockIntegration = core.defineIntegration((options) => {
    const anrThreshold = options?.threshold ?? 1000;
    const pollInterval = options?.pollInterval || anrThreshold / 2;
    return {
        name: 'EventLoopBlockRenderer',
        setup() {
            const config = {
                pollInterval,
                anrThreshold,
                captureStackTrace: true,
                ...options,
            };
            const ipc$1 = ipc.getIPC();
            // eslint-disable-next-line no-restricted-globals
            ipc$1.sendStatus({ status: document.visibilityState, config });
            setInterval(() => {
                ipc$1.sendStatus({ status: 'alive', config });
            }, config.pollInterval);
        },
    };
});

exports.eventLoopBlockIntegration = eventLoopBlockIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/9a5dd36e54f13fb9c0e74490ec44d080dbc5df50/node_modules/@sentry/electron/renderer/integrations/event-loop-block.js.map
