const core = require('@sentry/core');
const sessions = require('../sessions.js');

/** Tracks sessions as the main process lifetime. */
const mainProcessSessionIntegration = core.defineIntegration((options = {}) => {
    return {
        name: 'MainProcessSession',
        setup() {
            sessions.startSession(!!options.sendOnCreate);
            sessions.endSessionOnExit();
        },
    };
});

exports.mainProcessSessionIntegration = mainProcessSessionIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/8e4da76ad196925accaa169efcae28c45454cce0/node_modules/@sentry/electron/main/integrations/main-process-session.js.map
