import "./chunk-PXG64RU4.js";

// src/thenable.ts
import { noop } from "./utils.js";
function pendingThenable() {
  let resolve;
  let reject;
  const thenable = new Promise((_resolve, _reject) => {
    resolve = _resolve;
    reject = _reject;
  });
  thenable.status = "pending";
  thenable.catch(() => {
  });
  function finalize(data) {
    Object.assign(thenable, data);
    delete thenable.resolve;
    delete thenable.reject;
  }
  thenable.resolve = (value) => {
    finalize({
      status: "fulfilled",
      value
    });
    resolve(value);
  };
  thenable.reject = (reason) => {
    finalize({
      status: "rejected",
      reason
    });
    reject(reason);
  };
  return thenable;
}
function tryResolveSync(promise) {
  var _a;
  let data;
  (_a = promise.then((result) => {
    data = result;
    return result;
  }, noop)) == null ? void 0 : _a.catch(noop);
  if (data !== void 0) {
    return { data };
  }
  return void 0;
}
export {
  pendingThenable,
  tryResolveSync
};//# sourceMappingURL=http://go/sourcemap/sourcemaps/8cd6f62c4c264240eb1925773707665d0f5b25e0/node_modules/@tanstack/query-core/build/legacy/thenable.js.map